/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.TimestampValidationData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.TimeAttributeType;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(TimestampParserUtil.class);
    private ObjectFactory svpFactory;
    private int timestampIndex;
    private int maxTokenListSize;
    private Function<JAdESSignature, StreamProvider> digestGetter;
    private Consumer<List<? extends Timestamp>> signatureTimestampSetter;
    private Function<TimeAttributeType, JAXBElement<TimeAttributeType>> svpFactoryCreateMethod;
    private boolean isSignedHeaderParam;
    private boolean onlyCheckIndex0ForTstVd;

    public void setSvpFactory(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    public void setTimestampIndex(int timestampIndex) {
        this.timestampIndex = timestampIndex;
    }

    public void setMaxTokenListSize(int maxTokenListSize) {
        this.maxTokenListSize = maxTokenListSize;
    }

    public void setDigestGetter(Function<JAdESSignature, StreamProvider> digestGetter) {
        this.digestGetter = digestGetter;
    }

    public void setSignatureTimestampSetter(Consumer<List<? extends Timestamp>> signatureTimestampSetter) {
        this.signatureTimestampSetter = signatureTimestampSetter;
    }

    public void setSvpFactoryCreateMethod(Function<TimeAttributeType, JAXBElement<TimeAttributeType>> svpFactoryCreateMethod) {
        this.svpFactoryCreateMethod = svpFactoryCreateMethod;
    }

    public void setSignedHeaderParam(boolean isSignedHeaderParam) {
        this.isSignedHeaderParam = isSignedHeaderParam;
    }

    public void setOnlyCheckIndex0ForTstVd(boolean onlyCheckIndex0ForTstVd) {
        this.onlyCheckIndex0ForTstVd = onlyCheckIndex0ForTstVd;
    }

    public void processTimestampMap(JAdESSignature jadesSignature, Map<String, Object> tstMapContent) {
        ArrayList<TimestampedObject> timestamps = new ArrayList<TimestampedObject>();
        Object tokenListObj = tstMapContent.get("tstTokens");
        List<Object> tokenList = JsonWebSignatureHelper.parseJsonAsObjectList(tokenListObj);
        int tstTokenCntr = 0;
        for (Object tstToken : tokenList) {
            Map<String, Object> tstTokenMap;
            if (this.isTokenListSizeLimitReached(tstTokenCntr, this.maxTokenListSize)) break;
            if (!(tstToken instanceof Map) || !(tstTokenMap = JsonWebSignatureHelper.parseJsonAsMap(tstToken)).containsKey("val")) continue;
            Object tstTokenVal = tstTokenMap.get("val");
            List<TimestampedObject> timestampTokens = this.parseTimestampToken(tstTokenVal, jadesSignature);
            timestamps.addAll(timestampTokens);
            ++tstTokenCntr;
        }
        if (this.signatureTimestampSetter != null) {
            this.signatureTimestampSetter.accept(timestamps);
        }
    }

    private boolean isTokenListSizeLimitReached(int tstTokenCntr, int maxTokenListSize) {
        if (maxTokenListSize <= 0) {
            return false;
        }
        if (tstTokenCntr >= maxTokenListSize) {
            logger.warn("Shall include only {} timestamp(s), ignoring others", (Object)maxTokenListSize);
            return true;
        }
        return false;
    }

    private List<TimestampedObject> parseTimestampToken(Object token, JAdESSignature jadesSignature) {
        byte[] decodedToken = Base64.getDecoder().decode(token.toString());
        try {
            Map<String, Object> jwsProtectedHeaders = jadesSignature.getJwsProtectedHeaders();
            Object sigD = jwsProtectedHeaders.get("sigD");
            if (sigD != null) {
                return Collections.emptyList();
            }
            SignatureTimeStampToken signatureTimeStampToken = new SignatureTimeStampToken((Source)new BSource(decodedToken));
            TSPParser tspParser = new TSPParser((AlgorithmManager)new AlgorithmServiceFacade());
            List timestampedObjects = tspParser.parse(signatureTimeStampToken.getSignedData(), null);
            for (TimestampedObject timestampedObject : timestampedObjects) {
                if (this.digestGetter != null) {
                    timestampedObject.setTimestampedContent(this.digestGetter.apply(jadesSignature));
                }
                if (this.svpFactoryCreateMethod != null) {
                    this.addTimestampToSVP(jadesSignature, timestampedObject);
                }
                this.addValidationData(jadesSignature, timestampedObject);
            }
            return timestampedObjects;
        }
        catch (ParseException e) {
            return Collections.emptyList();
        }
    }

    private void addTimestampToSVP(JAdESSignature jadesSignature, TimestampedObject timestampedObject) {
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributes);
        }
        TimeAttributeType timeAttributeType = new TimeAttributeType();
        timeAttributeType.setSigned(Boolean.valueOf(this.isSignedHeaderParam));
        timeAttributeType.setTime(timestampedObject.getGenerationTime());
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.svpFactoryCreateMethod.apply(timeAttributeType));
    }

    private void addValidationData(JAdESSignature jadesSignature, TimestampedObject timestampedObject) {
        block1: {
            List<TimestampValidationData> tstVDList;
            block2: {
                tstVDList = jadesSignature.getTimestampValidationDataList();
                if (tstVDList.isEmpty()) break block1;
                if (!this.onlyCheckIndex0ForTstVd) break block2;
                TimestampValidationData firstTstVD = tstVDList.get(0);
                if (firstTstVD.getEtsiUIndex() != 0) break block1;
                this.setTstValidaionData(timestampedObject, firstTstVD);
                break block1;
            }
            ListIterator<TimestampValidationData> tstVDIt = tstVDList.listIterator(tstVDList.size());
            int indexAfterTimestamp = this.timestampIndex + 1;
            while (tstVDIt.hasPrevious()) {
                TimestampValidationData prevInList = tstVDIt.previous();
                if (prevInList.getEtsiUIndex() > indexAfterTimestamp) continue;
                this.setTstValidaionData(timestampedObject, prevInList);
                break;
            }
        }
    }

    private void setTstValidaionData(TimestampedObject timestampedObject, TimestampValidationData tstVD) {
        List<SignatureValidationDataAttachment<CRL>> crls;
        List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses;
        Set<SignatureValidationDataAttachment<X509Certificate>> certificates = tstVD.getCertificates();
        if (certificates != null && !certificates.isEmpty()) {
            timestampedObject.setAttachedCertificates(certificates);
        }
        if ((ocspResponses = tstVD.getOcspResponses()) != null && !ocspResponses.isEmpty()) {
            timestampedObject.setAttachedOCSPValues(ocspResponses);
        }
        if ((crls = tstVD.getCrls()) != null && !crls.isEmpty()) {
            timestampedObject.setAttachedCRLs(crls);
        }
    }
}

