/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.Base64Util;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESLongTermValidationDataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESLongTermValidationDataUtil.class);
    private static Base64Util base64Util = new Base64Util();
    private static final JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
    private static CertificateFactory cf;

    private JAdESLongTermValidationDataUtil() {
    }

    public static Set<SignatureValidationDataAttachment<X509Certificate>> addCertificates(BaseSignature signature, List<Object> xVals) {
        HashSet<SignatureValidationDataAttachment<X509Certificate>> allAttachedCertificates = signature.getAttachedCertificates();
        if (allAttachedCertificates == null) {
            allAttachedCertificates = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
            signature.setAttachedCertificates(allAttachedCertificates);
        }
        Set<SignatureValidationDataAttachment<X509Certificate>> newAttachedCertificates = JAdESLongTermValidationDataUtil.parseCertificates(xVals);
        allAttachedCertificates.addAll(newAttachedCertificates);
        return newAttachedCertificates;
    }

    public static Set<SignatureValidationDataAttachment<X509Certificate>> parseCertificates(List<Object> xVals) {
        HashSet<SignatureValidationDataAttachment<X509Certificate>> certificates = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        for (Object xValObject : xVals) {
            Map<String, Object> xVal;
            if (!(xValObject instanceof Map) || !((xVal = JsonWebSignatureHelper.parseJsonAsMap(xValObject)) instanceof Map) || !xVal.containsKey("x509Cert")) continue;
            Map<String, Object> x509Cert = JsonWebSignatureHelper.parseJsonAsMap(xVal.get("x509Cert"));
            try {
                byte[] decodedCertBytes = base64Util.decode(x509Cert.get("val").toString());
                X509Certificate certificate = JAdESLongTermValidationDataUtil.generateX509Certificate(decodedCertBytes);
                if (certificate == null) continue;
                certificates.add((SignatureValidationDataAttachment<X509Certificate>)new SignatureValidationDataAttachmentImpl((Object)certificate));
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.debug("Could not decode attached certificate", (Throwable)e);
            }
        }
        return certificates;
    }

    public static List<SignatureValidationDataAttachment<?>> addRevocationValues(BaseSignature signature, Map<String, Object> rVals) {
        Object crlValsListObj;
        Object ocspValsListObj;
        List<SignatureValidationDataAttachment<OCSPResp>> newAttachedOCSPValues = null;
        if (rVals.containsKey("ocspVals") && (ocspValsListObj = rVals.get("ocspVals")) instanceof List) {
            newAttachedOCSPValues = JAdESLongTermValidationDataUtil.addOcspRevocationValues(signature, JsonWebSignatureHelper.parseJsonAsObjectList(ocspValsListObj));
        }
        List<SignatureValidationDataAttachment<CRL>> newAttachedCRLs = null;
        if (rVals.containsKey("crlVals") && (crlValsListObj = rVals.get("crlVals")) instanceof List) {
            newAttachedCRLs = JAdESLongTermValidationDataUtil.addCrlRevocationValues(signature, JsonWebSignatureHelper.parseJsonAsObjectList(crlValsListObj));
        }
        if (rVals.containsKey("otherVals")) {
            LOG.warn("Ignoring '{}' list in '{}', not supported.", (Object)"otherVals", (Object)"rVals");
        }
        return JAdESLongTermValidationDataUtil.getCombinedLists(newAttachedOCSPValues, newAttachedCRLs);
    }

    private static List<SignatureValidationDataAttachment<?>> getCombinedLists(List<SignatureValidationDataAttachment<OCSPResp>> newAttachedOCSPValues, List<SignatureValidationDataAttachment<CRL>> newAttachedCRLs) {
        ArrayList combined = new ArrayList();
        if (newAttachedOCSPValues != null && !newAttachedOCSPValues.isEmpty()) {
            combined.addAll(newAttachedOCSPValues);
        }
        if (newAttachedCRLs != null && !newAttachedCRLs.isEmpty()) {
            combined.addAll(newAttachedCRLs);
        }
        return combined;
    }

    public static List<SignatureValidationDataAttachment<OCSPResp>> addOcspRevocationValues(BaseSignature signature, List<Object> ocspVals) {
        List<SignatureValidationDataAttachment<OCSPResp>> newAttachedOCSPValues;
        ArrayList<SignatureValidationDataAttachment<OCSPResp>> allAttachedOCSPValues = signature.getAttachedOCSPValues();
        if (allAttachedOCSPValues == null) {
            allAttachedOCSPValues = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
            signature.setAttachedOCSPValues(allAttachedOCSPValues);
        }
        if (!(newAttachedOCSPValues = JAdESLongTermValidationDataUtil.parseOcspRevocationValues(ocspVals)).isEmpty()) {
            allAttachedOCSPValues.addAll(newAttachedOCSPValues);
        }
        return newAttachedOCSPValues;
    }

    public static List<SignatureValidationDataAttachment<OCSPResp>> parseOcspRevocationValues(List<Object> ocspVals) {
        ArrayList<SignatureValidationDataAttachment<OCSPResp>> ocspValues = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
        for (Object ocspValObject : ocspVals) {
            try {
                Map<String, Object> ocspVal = JsonWebSignatureHelper.parseJsonAsMap(ocspValObject);
                String ocspB64ValStr = ocspVal.get("val").toString();
                byte[] ocspValBytes = base64Util.decode(ocspB64ValStr);
                OCSPResp ocspResp = new OCSPResp(ocspValBytes);
                SignatureValidationDataAttachmentImpl ocspAtt = new SignatureValidationDataAttachmentImpl((Object)ocspResp);
                ocspValues.add((SignatureValidationDataAttachment<OCSPResp>)ocspAtt);
            }
            catch (Exception e) {
                LOG.debug("Could not decode attached OCSP value", (Throwable)e);
            }
        }
        return ocspValues;
    }

    public static List<SignatureValidationDataAttachment<CRL>> addCrlRevocationValues(BaseSignature signature, List<Object> crlVals) {
        List<SignatureValidationDataAttachment<CRL>> newAttachedCRLValues;
        ArrayList<SignatureValidationDataAttachment<CRL>> allAttachedCRLValues = signature.getAttachedCRLs();
        if (allAttachedCRLValues == null) {
            allAttachedCRLValues = new ArrayList<SignatureValidationDataAttachment<CRL>>();
            signature.setAttachedCRLs(allAttachedCRLValues);
        }
        if (!(newAttachedCRLValues = JAdESLongTermValidationDataUtil.parseCrlRevocationValues(crlVals)).isEmpty()) {
            allAttachedCRLValues.addAll(newAttachedCRLValues);
        }
        return newAttachedCRLValues;
    }

    public static List<SignatureValidationDataAttachment<CRL>> parseCrlRevocationValues(List<Object> crlVals) {
        ArrayList<SignatureValidationDataAttachment<CRL>> crlValues = new ArrayList<SignatureValidationDataAttachment<CRL>>();
        for (Object crlValObject : crlVals) {
            try {
                Map<String, Object> crlValMap = JsonWebSignatureHelper.parseJsonAsMap(crlValObject);
                String crlValB64Str = crlValMap.get("val").toString();
                byte[] crlValBytes = base64Util.decode(crlValB64Str);
                X509CRL crlVal = jcaX509CRLConverter.getCRL(new X509CRLHolder(crlValBytes));
                SignatureValidationDataAttachmentImpl crlAtt = new SignatureValidationDataAttachmentImpl((Object)crlVal);
                crlValues.add((SignatureValidationDataAttachment<CRL>)crlAtt);
            }
            catch (Exception e) {
                LOG.debug("Could not decode attached CRL value", (Throwable)e);
            }
        }
        return crlValues;
    }

    public static void addAttachmentsFromTstVDContainer(BaseSignature signature, Map<String, Object> tstVD) {
        if (tstVD != null && tstVD.containsKey("xVals")) {
            JAdESLongTermValidationDataUtil.addCertificates(signature, JsonWebSignatureHelper.parseJsonAsObjectList(tstVD.get("xVals")));
        }
        if (tstVD != null && tstVD.containsKey("rVals")) {
            JAdESLongTermValidationDataUtil.addRevocationValues(signature, JsonWebSignatureHelper.parseJsonAsMap(tstVD.get("rVals")));
        }
    }

    private static X509Certificate generateX509Certificate(byte[] encode) throws GeneralSecurityException, IOException {
        if (cf != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(encode);){
                X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(bais);
                return x509Certificate;
            }
        }
        return null;
    }

    static {
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            LOG.error("Could not set up CertificateFactory", (Throwable)e);
        }
    }
}

