/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import de.governikus.csl.jades.JAdESOID;
import de.governikus.csl.jades.JAdESSignaturePolicyId;
import de.governikus.csl.jades.JAdESSignaturePolicyQualifier;
import de.governikus.csl.jades.JAdESSignaturePolicyStore;
import de.governikus.csl.jades.JAdESSignaturePolicyUserNotice;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.Base64Util;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderParameterFactory {
    private static final Logger logger = LoggerFactory.getLogger(HeaderParameterFactory.class);
    private static final Base64Util base64Util = new Base64Util();
    private static final String SIG_POL_DOC = "sigPolDoc";
    private static final String SIG_POL_LOCAL_URI = "sigPolLocalURI";
    private static final String SIG_POL_DOC_SPEC = "spDSpec";
    private static final String OID_ID = "id";
    private static final String OID_DESC = "desc";
    private static final String OID_DOC_REFS = "docRefs";
    private static final String SIG_PID_ID = "id";
    private static final String SIG_PID_DIG_ALG = "digAlg";
    private static final String SIG_PID_DIG_VAL = "digVal";
    private static final String SIG_PID_DIG_PSP = "digPSp";
    private static final String SIG_PID_SIG_QUALS = "sigPQuals";
    private static final String SP_USER_NOTICE = "spUserNotice";
    private static final String SP_URI = "spURI";
    private static final String SP_DOC_SPEC = "spDSpec";
    private static final String USER_NOTICE_REF = "noticeRef";
    private static final String USER_NOTICE_REF_ORGANIZATION = "organization";
    private static final String USER_NOTICE_REF_NUMBERS = "noticeNumbers";
    private static final String USER_NOTICE_EXPL_TEXT = "explText";

    public JAdESSignaturePolicyStore parseSignaturePolicyStore(Object obj) {
        if (obj instanceof Map) {
            return this.parseSignaturePolicyStore(JsonWebSignatureHelper.parseJsonAsMap(obj));
        }
        return null;
    }

    public JAdESSignaturePolicyStore parseSignaturePolicyStore(Map<String, Object> sigPstMap) {
        JAdESSignaturePolicyStore jadesSigPst = new JAdESSignaturePolicyStore();
        this.parsePolicyBytes(sigPstMap, jadesSigPst);
        this.parsePolicyURI(sigPstMap, jadesSigPst);
        this.parsePolicyDocSpec(sigPstMap, jadesSigPst);
        return jadesSigPst;
    }

    private void parsePolicyBytes(Map<String, Object> sigPstMap, JAdESSignaturePolicyStore jadesSigPst) {
        Object policyBytesb64 = sigPstMap.get(SIG_POL_DOC);
        if (policyBytesb64 instanceof String) {
            try {
                jadesSigPst.setSignaturePolicyBytes(base64Util.decode((String)policyBytesb64));
            }
            catch (Exception e) {
                logger.error("Cannot decode signature policy bytes", (Throwable)e);
            }
        }
    }

    private void parsePolicyURI(Map<String, Object> sigPstMap, JAdESSignaturePolicyStore jadesSigPst) {
        Object policyURI = sigPstMap.get(SIG_POL_LOCAL_URI);
        if (policyURI instanceof String) {
            jadesSigPst.setSignaturePolicyLocalURI((String)policyURI);
        }
    }

    private void parsePolicyDocSpec(Map<String, Object> sigPstMap, JAdESSignaturePolicyStore jadesSigPst) {
        Object docSpec = sigPstMap.get("spDSpec");
        jadesSigPst.setSignaturePolicyDocumentSpecification(this.parseOid(docSpec));
    }

    public JAdESOID parseOid(Object obj) {
        if (obj instanceof Map) {
            return this.parseOid(JsonWebSignatureHelper.parseJsonAsMap(obj));
        }
        return null;
    }

    public JAdESOID parseOid(Map<String, Object> jadesOidMap) {
        JAdESOID jadesOid = new JAdESOID();
        this.getAndSet(jadesOidMap, "id", jadesOid::setId);
        this.getAndSet(jadesOidMap, OID_DESC, jadesOid::setDesc);
        this.getAndSetDocRefs(jadesOidMap, jadesOid);
        return jadesOid;
    }

    private void getAndSet(Map<String, Object> jadesOidMap, String mapKey, Consumer<String> setter) {
        Object mapValue = jadesOidMap.get(mapKey);
        if (mapValue instanceof String) {
            setter.accept((String)mapValue);
        }
    }

    private void getAndSetDocRefs(Map<String, Object> jadesOidMap, JAdESOID jadesOid) {
        Object docRefsObj = jadesOidMap.get(OID_DOC_REFS);
        if (docRefsObj instanceof List) {
            ArrayList<String> parsedDocRefs = new ArrayList<String>();
            for (Object docRef : JsonWebSignatureHelper.parseJsonAsObjectList(docRefsObj)) {
                if (!(docRef instanceof String)) continue;
                parsedDocRefs.add((String)docRef);
            }
            if (!parsedDocRefs.isEmpty()) {
                jadesOid.setDocRefs(parsedDocRefs);
            }
        }
    }

    public JAdESSignaturePolicyId parseSignaturePolicyId(Object obj) {
        if (obj instanceof Map) {
            return this.parseSignaturePolicyId(JsonWebSignatureHelper.parseJsonAsMap(obj));
        }
        return null;
    }

    public JAdESSignaturePolicyId parseSignaturePolicyId(Map<String, Object> sigPIdMap) {
        JAdESSignaturePolicyId jadesSigPId = new JAdESSignaturePolicyId();
        this.parseId(sigPIdMap, jadesSigPId);
        this.parseDigestComputedAsDefiniedInSpecification(sigPIdMap, jadesSigPId);
        this.parseDigestAlgorithm(sigPIdMap, jadesSigPId);
        this.parseDigestValueBytes(sigPIdMap, jadesSigPId);
        this.parsePolicyQualifiers(sigPIdMap, jadesSigPId);
        return jadesSigPId;
    }

    private void parseId(Map<String, Object> sigPIdMap, JAdESSignaturePolicyId jadesSigPId) {
        Object id = sigPIdMap.get("id");
        jadesSigPId.setSignaturePolicyId(this.parseOid(id));
    }

    private void parseDigestAlgorithm(Map<String, Object> sigPIdMap, JAdESSignaturePolicyId jadesSigPId) {
        Object digAlg = sigPIdMap.get(SIG_PID_DIG_ALG);
        if (digAlg instanceof String) {
            jadesSigPId.setSignaturePolicyDigestAlgorithm((String)digAlg);
        }
    }

    private void parseDigestValueBytes(Map<String, Object> sigPIdMap, JAdESSignaturePolicyId jadesSigPId) {
        Object digValb64 = sigPIdMap.get(SIG_PID_DIG_VAL);
        if (digValb64 instanceof String) {
            try {
                jadesSigPId.setSignaturePolicyDigestValue(Base64.getUrlDecoder().decode((String)digValb64));
            }
            catch (IllegalArgumentException e) {
                try {
                    jadesSigPId.setSignaturePolicyDigestValue(Base64.getDecoder().decode((String)digValb64));
                }
                catch (Exception decodingException) {
                    logger.error("Cannot decode policy digest bytes", (Throwable)decodingException);
                }
            }
        }
    }

    private void parseDigestComputedAsDefiniedInSpecification(Map<String, Object> sigPIdMap, JAdESSignaturePolicyId jadesSigPId) {
        Object digPSp = sigPIdMap.get(SIG_PID_DIG_PSP);
        if (digPSp instanceof Boolean) {
            jadesSigPId.setDigestComputedAsDefiniedInSpecification((Boolean)digPSp);
        }
    }

    private void parsePolicyQualifiers(Map<String, Object> sigPIdMap, JAdESSignaturePolicyId jadesSigPId) {
        Object qualifierListObj = sigPIdMap.get(SIG_PID_SIG_QUALS);
        if (qualifierListObj instanceof List) {
            ArrayList<JAdESSignaturePolicyQualifier> qualifiers = new ArrayList<JAdESSignaturePolicyQualifier>();
            for (Object obj : (List)qualifierListObj) {
                JAdESSignaturePolicyQualifier qualifier = this.parseSignaturePolicyQualifier(obj);
                if (qualifier == null) continue;
                qualifiers.add(qualifier);
            }
            if (!qualifiers.isEmpty()) {
                jadesSigPId.setSigngaturePolicyQualifiers(qualifiers);
            }
        }
    }

    public JAdESSignaturePolicyQualifier parseSignaturePolicyQualifier(Object obj) {
        if (obj instanceof Map) {
            return this.parseSignaturePolicyQualifier(JsonWebSignatureHelper.parseJsonAsMap(obj));
        }
        return null;
    }

    public JAdESSignaturePolicyQualifier parseSignaturePolicyQualifier(Map<String, Object> sigPQualsMap) {
        JAdESSignaturePolicyQualifier jadesSigPolQuals = new JAdESSignaturePolicyQualifier();
        this.parsePolicyDownloadURL(sigPQualsMap, jadesSigPolQuals);
        this.parsePolicyDocSpec(sigPQualsMap, jadesSigPolQuals);
        this.parsePolicyUserNotice(sigPQualsMap, jadesSigPolQuals);
        return jadesSigPolQuals;
    }

    private void parsePolicyDownloadURL(Map<String, Object> sigPQualsMap, JAdESSignaturePolicyQualifier jadesSigPolQuals) {
        Object policyURI = sigPQualsMap.get(SP_URI);
        if (policyURI instanceof String) {
            jadesSigPolQuals.setSignaturePolicyDownloadURL((String)policyURI);
        }
    }

    private void parsePolicyDocSpec(Map<String, Object> sigPQualsMap, JAdESSignaturePolicyQualifier jadesSigPolQuals) {
        Object docSpec = sigPQualsMap.get("spDSpec");
        jadesSigPolQuals.setSignaturePolicyDocumentSpecification(this.parseOid(docSpec));
    }

    private void parsePolicyUserNotice(Map<String, Object> sigPQualsMap, JAdESSignaturePolicyQualifier jadesSigPolQuals) {
        Object policyUserNotice = sigPQualsMap.get(SP_USER_NOTICE);
        jadesSigPolQuals.setSignaturePolicyUserNotice(this.parseSignaturePolicyUserNotice(policyUserNotice));
    }

    public JAdESSignaturePolicyUserNotice parseSignaturePolicyUserNotice(Object obj) {
        if (obj instanceof Map) {
            return this.parseSignaturePolicyUserNotice(JsonWebSignatureHelper.parseJsonAsMap(obj));
        }
        return null;
    }

    public JAdESSignaturePolicyUserNotice parseSignaturePolicyUserNotice(Map<String, Object> sigPUserNoticeMap) {
        JAdESSignaturePolicyUserNotice jadesSigPolUserNotice = new JAdESSignaturePolicyUserNotice();
        this.parseNoticeReferences(sigPUserNoticeMap, jadesSigPolUserNotice);
        this.parseExplicitText(sigPUserNoticeMap, jadesSigPolUserNotice);
        return jadesSigPolUserNotice;
    }

    private void parseNoticeReferences(Map<String, Object> sigPUserNoticeMap, JAdESSignaturePolicyUserNotice jadesSigPolUserNotice) {
        Object noticeRef = sigPUserNoticeMap.get(USER_NOTICE_REF);
        if (noticeRef instanceof Map) {
            Map noticeRefMap = (Map)noticeRef;
            this.parseOrganization(noticeRefMap, jadesSigPolUserNotice);
            this.parseNoticeNumbers(noticeRefMap, jadesSigPolUserNotice);
        }
    }

    private void parseNoticeNumbers(Map<String, Object> noticeRefMap, JAdESSignaturePolicyUserNotice jadesSigPolUserNotice) {
        Object refNrsObj = noticeRefMap.get(USER_NOTICE_REF_NUMBERS);
        if (refNrsObj instanceof List) {
            ArrayList<Integer> refNrs = new ArrayList<Integer>();
            for (Object refNr : (List)refNrsObj) {
                if (!(refNr instanceof Integer)) continue;
                refNrs.add((Integer)refNr);
            }
            if (!refNrs.isEmpty()) {
                jadesSigPolUserNotice.setNoticeNumbers(refNrs);
            }
        }
    }

    private void parseOrganization(Map<String, Object> noticeRefMap, JAdESSignaturePolicyUserNotice jadesSigPolUserNotice) {
        Object oragnization = noticeRefMap.get(USER_NOTICE_REF_ORGANIZATION);
        if (oragnization instanceof String) {
            jadesSigPolUserNotice.setOrganization((String)oragnization);
        }
    }

    private void parseExplicitText(Map<String, Object> sigPUserNoticeMap, JAdESSignaturePolicyUserNotice jadesSigPolUserNotice) {
        Object explText = sigPUserNoticeMap.get(USER_NOTICE_EXPL_TEXT);
        if (explText instanceof String) {
            jadesSigPolUserNotice.setExplicitText((String)explText);
        }
    }
}

