/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.jades.JAdESCertificateReference;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.utils.SignatureAttributesUtils;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validation.CertificateReferenceImpl;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;

public class DigestUtil {
    private static final ObjectFactory svpFactory = new ObjectFactory();

    private DigestUtil() {
    }

    public static de.governikus.csl.validate.svp.DigestAlgorithm getDigestAlgorithmForJwsName(String digAlgJwsName) {
        DigestAlgorithm hashAlgorithm;
        String digAlgJcaName = JsonWebSignatureHelper.mapJWSAlgoToJCA(digAlgJwsName);
        if (digAlgJcaName != null && (hashAlgorithm = AlgorithmService.getDigestForJCAName((String)digAlgJcaName)) != null) {
            return SVPFactory.createDigestAlgorithm((DigestAlgorithm)hashAlgorithm);
        }
        de.governikus.csl.validate.svp.DigestAlgorithm digestAlgorithm = new de.governikus.csl.validate.svp.DigestAlgorithm();
        digestAlgorithm.setName(digAlgJwsName);
        return digestAlgorithm;
    }

    public static de.governikus.csl.validate.svp.DigestAlgorithm getDigestAlgorithmForJcaName(String digAlgJcaName) {
        DigestAlgorithm hashAlgorithm = AlgorithmService.getDigestForJCAName((String)digAlgJcaName);
        if (hashAlgorithm != null) {
            return SVPFactory.createDigestAlgorithm((DigestAlgorithm)hashAlgorithm);
        }
        de.governikus.csl.validate.svp.DigestAlgorithm digestAlgorithm = new de.governikus.csl.validate.svp.DigestAlgorithm();
        digestAlgorithm.setName(digAlgJcaName);
        return digestAlgorithm;
    }

    public static List<CertificateReference> getSignCertRefs(JAdESSignature jadesSignature) {
        ArrayList signCertRefs = jadesSignature.getSigningCertificateReferences();
        if (signCertRefs == null) {
            signCertRefs = new ArrayList();
            jadesSignature.setSigningCertificateReferences(signCertRefs);
        }
        return signCertRefs;
    }

    public static byte[] getIssuerSerialBytes(X509Certificate x509Cert) {
        try {
            return DigestUtil.getIssuerSerial(x509Cert).getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IssuerSerial getIssuerSerial(X509Certificate x509Cert) {
        try {
            GeneralNames gns = new GeneralNames(new GeneralName(X500Name.getInstance((Object)x509Cert.getIssuerX500Principal().getEncoded())));
            return new IssuerSerial(gns, x509Cert.getSerialNumber());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void addSigningCertificateReferenceToSvp(JAdESSignature jadesSignature, JAdESCertificateReference jadesCertRef) {
        SignatureAttributesType signatureAttributes = DigestUtil.getSignatureAttributes(jadesSignature);
        CertIDListType signCertIDListType = (CertIDListType)SignatureAttributesUtils.findByNameAndType((String)"signingCertificate", CertIDListType.class, (List)signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat());
        if (signCertIDListType == null) {
            signCertIDListType = new CertIDListType();
            signCertIDListType.setSigned(Boolean.valueOf(true));
            signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(svpFactory.createSignatureAttributesTypeSigningCertificate(signCertIDListType));
        }
        List certRefList = signCertIDListType.getCertID();
        CertIDType signCertID = new CertIDType();
        signCertID.setDigestMethod(DigestUtil.getDigestAlgorithm(jadesCertRef));
        signCertID.setDigestValue(jadesCertRef.getDigestValue());
        certRefList.add(signCertID);
    }

    private static SignatureAttributesType getSignatureAttributes(JAdESSignature jadesSignature) {
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributes);
        }
        return signatureAttributes;
    }

    private static de.governikus.csl.validate.svp.DigestAlgorithm getDigestAlgorithm(CertificateReferenceImpl certRefImpl) {
        try {
            return DigestUtil.getDigestAlgorithmForJcaName(certRefImpl.getDigestAlgorithm().getJCAName());
        }
        catch (Exception e) {
            return null;
        }
    }
}

