/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import java.util.Arrays;
import java.util.Base64;

public class Base64Util {
    private final Base64.Encoder urlSafeEncoderWithoutPadding = Base64.getUrlEncoder().withoutPadding();
    private final Base64.Decoder decoder = Base64.getDecoder();
    private static final byte[] B64URL_ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};

    public String encodeUrlSafeWithoutPadding(byte[] bytesToEncode) {
        return this.urlSafeEncoderWithoutPadding.encodeToString(bytesToEncode);
    }

    public byte[] decode(String stringToDecode) {
        return this.decoder.decode(stringToDecode);
    }

    public byte[] decode(byte[] bytesToDecode) {
        return this.decoder.decode(bytesToDecode);
    }

    public boolean isB64UrlString(Object input) {
        if (input instanceof String) {
            for (byte b : ((String)input).getBytes()) {
                if (this.isB64UrlChar(b)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isB64UrlChar(byte b) {
        return Arrays.binarySearch(B64URL_ENCODING_TABLE, b) >= 0;
    }

    static {
        Arrays.sort(B64URL_ENCODING_TABLE);
    }
}

