/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.json.EtsiUConformityException;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.EtsiUHeaderParams;
import de.governikus.csl.jades.util.Base64Util;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonWebSignatureHelper {
    private static Base64Util base64Util = new Base64Util();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Map<String, String> algorithms = new HashMap<String, String>();
    private static final List<String> critHeaderNames = new ArrayList<String>();
    private static final String ETSI_U_HEADER_NAME = "etsiU";

    private JsonWebSignatureHelper() {
    }

    public static String mapJWSAlgoToJCA(String alg) {
        return algorithms.get(alg);
    }

    public static boolean isCrit(String header) {
        return critHeaderNames.contains(header);
    }

    public static EtsiUHeaderParams parseEtsiUHeader(JAdESSignature sig) throws EtsiUConformityException {
        if (!JsonWebSignatureHelper.checkEtsiUHeaderElementConformity(sig)) {
            throw new EtsiUConformityException("etsiU header contains mixed elements");
        }
        Map<String, Object> jwsUnprotectedHeaders = sig.getJwsUnprotectedHeaders();
        if (jwsUnprotectedHeaders == null || !jwsUnprotectedHeaders.containsKey(ETSI_U_HEADER_NAME)) {
            return null;
        }
        List values = (List)mapper.convertValue(jwsUnprotectedHeaders.get(ETSI_U_HEADER_NAME), (TypeReference)new TypeReference<List<Object>>(){});
        EtsiUHeaderParams etsiUHeaderParams = new EtsiUHeaderParams();
        for (Object value : values) {
            EtsiUHeaderParamElement etsiUHeaderParamElement = null;
            etsiUHeaderParamElement = value instanceof String ? new EtsiUHeaderParamElement((String)value, JsonWebSignatureHelper.parseJsonAsMap(Base64.getUrlDecoder().decode((String)value))) : new EtsiUHeaderParamElement(JsonWebSignatureHelper.parseJsonAsMap(value));
            etsiUHeaderParams.add(etsiUHeaderParamElement);
        }
        return etsiUHeaderParams;
    }

    public static Map<String, Object> parseEtsiUHeaderElement(Object element) throws JsonProcessingException {
        if (element instanceof Map) {
            return (Map)element;
        }
        if (element instanceof String && base64Util.isB64UrlString(element)) {
            byte[] decoded = Base64.getUrlDecoder().decode(((String)element).getBytes());
            String decString = new String(decoded, StandardCharsets.UTF_8);
            return (Map)mapper.readValue(decString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return null;
    }

    public static List<Object> getEtsiUElementList(JAdESSignature sig) {
        Map<String, Object> jwsUnprotectedHeaders = sig.getJwsUnprotectedHeaders();
        if (jwsUnprotectedHeaders == null || !jwsUnprotectedHeaders.containsKey(ETSI_U_HEADER_NAME)) {
            return Collections.emptyList();
        }
        return (List)jwsUnprotectedHeaders.get(ETSI_U_HEADER_NAME);
    }

    public static List<Object> getEtsiUElementByName(JAdESSignature sig, String etsiUElementName) throws JsonProcessingException {
        ArrayList<Object> results = new ArrayList<Object>();
        Map<String, Object> jwsUnprotectedHeaders = sig.getJwsUnprotectedHeaders();
        if (jwsUnprotectedHeaders != null && jwsUnprotectedHeaders.containsKey(ETSI_U_HEADER_NAME)) {
            List etsiUElements = (List)jwsUnprotectedHeaders.get(ETSI_U_HEADER_NAME);
            for (Object element : etsiUElements) {
                Map<String, Object> etsiUHeaderElement = JsonWebSignatureHelper.parseEtsiUHeaderElement(element);
                if (etsiUHeaderElement == null || !etsiUHeaderElement.containsKey(etsiUElementName)) continue;
                results.add(etsiUHeaderElement.get(etsiUElementName));
            }
        }
        return results;
    }

    public static Map<String, Object> parseJsonAsMap(byte[] json) {
        try {
            return (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T fromJSON(String json, Class<T> type) throws IOException {
        return (T)mapper.readValue(json, type);
    }

    public static Map<String, Object> parseJsonAsMap(Object json) {
        return (Map)mapper.convertValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static List<Object> parseJsonAsObjectList(Object json) {
        return (List)mapper.convertValue(json, (TypeReference)new TypeReference<List<Object>>(){});
    }

    public static boolean checkEtsiUHeaderElementConformity(JAdESSignature sig) {
        List<Object> etsiUElementList = JsonWebSignatureHelper.getEtsiUElementList(sig);
        return etsiUElementList.isEmpty() || JsonWebSignatureHelper.isAllB64(etsiUElementList) || JsonWebSignatureHelper.isAllClearFormat(etsiUElementList);
    }

    public static boolean isAllClearFormat(List<Object> elements) {
        for (Object obj : elements) {
            if (obj instanceof Map) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllB64(List<Object> elements) {
        for (Object obj : elements) {
            if (base64Util.isB64UrlString(obj)) continue;
            return false;
        }
        return true;
    }

    static {
        algorithms.put("RS256", "SHA256withRSA");
        algorithms.put("RS512", "SHA512withRSA");
        algorithms.put("ES256", "SHA256withECDSA");
        algorithms.put("ES512", "SHA512withECDSA");
        algorithms.put("S256", "SHA-256");
        algorithms.put("S384", "SHA-384");
        algorithms.put("S512", "SHA-512");
        critHeaderNames.add("sigT");
        critHeaderNames.add("x5t#o");
        critHeaderNames.add("sigX5ts");
        critHeaderNames.add("srCms");
        critHeaderNames.add("sigPl");
        critHeaderNames.add("srAts");
        critHeaderNames.add("adoTst");
        critHeaderNames.add("sigPId");
        critHeaderNames.add("sigD");
    }
}

