/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class JsonWebSignature {
    public static final String JADES_HEADER_PARAMETER_NAME_BASE64 = "b64";
    public static final String JADES_HEADER_PARAMETER_NAME_CERTIFICATE_CHAIN = "x5c";
    public static final String JADES_HEADER_PARAMETER_NAME_CERTIFICATE_CHAIN_URL = "x5u";
    public static final String JADES_HEADER_PARAMETER_NAME_COMMITMENT_TYPE_INDICATION = "srCms";
    public static final String JADES_HEADER_PARAMETER_NAME_CONTENT_TIMESTAMPS = "adoTst";
    public static final String JADES_HEADER_PARAMETER_NAME_CONTENT_TYPE = "cty";
    public static final String JADES_HEADER_PARAMETER_NAME_CRIT = "crit";
    public static final String JADES_HEADER_PARAMETER_NAME_DETACHED_CONTENT = "sigD";
    public static final String JADES_HEADER_PARAMETER_NAME_KEY_ID = "kid";
    public static final String JADES_HEADER_PARAMETER_NAME_OTHER_X509_DIGEST = "x5t#o";
    public static final String JADES_HEADER_PARAMETER_NAME_OTHER_X509_DIGESTS = "sigX5ts";
    public static final String JADES_HEADER_PARAMETER_NAME_SHA1_X509_DIGEST = "x5t";
    public static final String JADES_HEADER_PARAMETER_NAME_SHA256_X509_DIGEST = "x5t#S256";
    public static final String JADES_HEADER_PARAMETER_NAME_SIGNATURE_ALGORITHM = "alg";
    public static final String JADES_HEADER_PARAMETER_NAME_SIGNATURE_PRODUCTION_PLACE = "sigPl";
    public static final String JADES_HEADER_PARAMETER_NAME_SIGNER_ATTRIBUTES = "srAts";
    public static final String JADES_HEADER_PARAMETER_NAME_SIGNING_TIME = "sigT";
    public static final String JADES_HEADER_PARAMETER_NAME_SIGPID = "sigPId";
    public static final String JADES_MEMBER_NAME_DIG_ALG = "digAlg";
    public static final String JADES_MEMBER_NAME_DIG_VAL = "digVal";
    public static final String JADES_MEMBER_NAME_REVOCATION_CRL_REFERENCES = "crlRefs";
    public static final String JADES_MEMBER_NAME_REVOCATION_CRL_VALUES = "crlVals";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCES = "ocspRefs";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCE_ID = "ocspId";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCE_PRODUCEDAT = "producedAt";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCE_RESPONDERID = "responderId";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCE_RESPONDERID_BYKEY = "byKey";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_REFERENCE_RESPONDERID_BYNAME = "byName";
    public static final String JADES_MEMBER_NAME_REVOCATION_OCSP_VALUES = "ocspVals";
    public static final String JADES_MEMBER_NAME_REVOCATION_OTHER_VALUES = "otherVals";
    public static final String JADES_MEMBER_NAME_TIMESTAMP_TOKENS = "tstTokens";
    public static final String JADES_MEMBER_NAME_VALUE = "val";
    public static final String JADES_MEMBER_NAME_X509_CERTIFICATE = "x509Cert";
    public static final String JADES_ETSI_U_HEADER_PARAMETER_NAME = "etsiU";
    public static final String JADES_ETSI_U_MEMBER_ARCHIVE_TIMESTAMP_TOKEN = "arcTst";
    public static final String JADES_ETSI_U_MEMBER_ATTR_CERTIFICATE_REFERENCES = "axRefs";
    public static final String JADES_ETSI_U_MEMBER_ATTR_CERTIFICATE_VALUES = "axVals";
    public static final String JADES_ETSI_U_MEMBER_ATTR_REVOCATION_REFERENCES = "arRefs";
    public static final String JADES_ETSI_U_MEMBER_ATTR_REVOCATION_VALUES = "arVals";
    public static final String JADES_ETSI_U_MEMBER_CERTIFICATE_REFERENCES = "xRefs";
    public static final String JADES_ETSI_U_MEMBER_CERTIFICATE_VALUES = "xVals";
    public static final String JADES_ETSI_U_MEMBER_COUNTER_SIGNATURE = "cSig";
    public static final String JADES_ETSI_U_MEMBER_REFERENCES_TIMESTAMPS = "rfsTst";
    public static final String JADES_ETSI_U_MEMBER_REVOCATION_REFERENCES = "rRefs";
    public static final String JADES_ETSI_U_MEMBER_REVOCATION_VALUES = "rVals";
    public static final String JADES_ETSI_U_MEMBER_SIGNATURE_POLICY_STORE = "sigPSt";
    public static final String JADES_ETSI_U_MEMBER_SIGNATURE_TIMESTAMP_TOKEN = "sigTst";
    public static final String JADES_ETSI_U_MEMBER_SIG_VAL_SIGTST_AND_REFERENCES_TIMESTAMPS = "sigRTst";
    public static final String JADES_ETSI_U_MEMBER_TSTVD = "tstVD";
    @JsonProperty(value="payload")
    private String payload;
    @JsonProperty(value="protected")
    private String protectedHeaders;
    @JsonProperty(value="signature")
    private String signature;
    @JsonProperty(value="header")
    private Map<String, Object> header;
    @JsonProperty(value="signatures")
    private List<JsonWebSignature> signatures;

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getProtectedHeaders() {
        return this.protectedHeaders;
    }

    public void setProtectedHeaders(String protectedHeaders) {
        this.protectedHeaders = protectedHeaders;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public List<JsonWebSignature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<JsonWebSignature> signatures) {
        this.signatures = signatures;
    }

    public Map<String, Object> getDecodedProtectedHeader() {
        if (this.protectedHeaders == null) {
            return null;
        }
        return JsonWebSignatureHelper.parseJsonAsMap(Base64.getUrlDecoder().decode(this.protectedHeaders));
    }

    public byte[] getDecodedSignatureValue() {
        if (this.signature == null) {
            return new byte[0];
        }
        return Base64.getUrlDecoder().decode(this.signature);
    }

    public static byte[] getSignatureInput(String protectedHeaders, String payload) {
        return (protectedHeaders + "." + payload).getBytes(StandardCharsets.US_ASCII);
    }
}

