/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.governikus.csl.jades.json.SortingJsonNodeFactory;
import java.io.IOException;
import java.util.Map;

public class JsonCanonicalizerUtil {
    private ObjectMapper sortingMapper = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingJsonNodeFactory())).build();

    public String canonicalizeJsonMapAsString(Map<String, Object> testMap) throws JsonProcessingException {
        JsonNode canonicalizedJsonNode = this.canonicalizeJsonMapAsNode(testMap);
        return canonicalizedJsonNode.toString();
    }

    public Map<String, Object> canonicalizeJsonMapAsMap(Map<String, Object> testMap) throws JsonProcessingException {
        JsonNode canonicalizedJsonMapAsNode = this.canonicalizeJsonMapAsNode(testMap);
        return (Map)this.sortingMapper.convertValue((Object)canonicalizedJsonMapAsNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public JsonNode canonicalizeJsonMapAsNode(Map<String, Object> testMap) throws JsonProcessingException {
        return this.sortingMapper.readTree(this.sortingMapper.writeValueAsString(testMap));
    }

    public String canonicalizeJsonStringAsString(String jsonString) throws IOException {
        JsonNode readTree = this.canonicalizeJsonStringAsNode(jsonString);
        return readTree.toString();
    }

    public Map<String, Object> canonicalizeJsonStringAsMap(String jsonString) throws IOException {
        JsonNode node = this.canonicalizeJsonStringAsNode(jsonString);
        return (Map)this.sortingMapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public JsonNode canonicalizeJsonStringAsNode(String jsonString) throws IOException {
        return this.sortingMapper.readTree(jsonString);
    }
}

