/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.json;

import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class EtsiUHeaderParams
implements Iterable<EtsiUHeaderParamElement> {
    private static final List<String> rfsHeaderParamNames = Arrays.asList("xRefs", "axRefs", "rRefs", "arRefs");
    private static final List<String> rfsTstImprintHeaderParamNames = new ArrayList<String>();
    private static final List<String> sigRTstImprintHeaderParamNames = new ArrayList<String>();
    private List<EtsiUHeaderParamElement> headerParamElements = new ArrayList<EtsiUHeaderParamElement>();

    public void add(EtsiUHeaderParamElement element) {
        element.setEtsiUIndex(this.headerParamElements.size());
        this.headerParamElements.add(element);
    }

    @Override
    public Iterator<EtsiUHeaderParamElement> iterator() {
        return this.headerParamElements.iterator();
    }

    public Stream<EtsiUHeaderParamElement> stream() {
        return this.headerParamElements.stream();
    }

    public int size() {
        return this.headerParamElements.size();
    }

    public boolean isEmpty() {
        return this.headerParamElements.isEmpty();
    }

    public boolean contains(String name) {
        for (EtsiUHeaderParamElement element : this) {
            if (!element.getParameterMap().containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public EtsiUHeaderParamElement getParamElemByIndex(int index) {
        if (index < this.size()) {
            return this.headerParamElements.get(index);
        }
        return null;
    }

    public Map<String, Object> getParamMapByIndex(int index) {
        EtsiUHeaderParamElement paramElemByIndex = this.getParamElemByIndex(index);
        if (paramElemByIndex != null) {
            return paramElemByIndex.getParameterMap();
        }
        return null;
    }

    public Map<String, Object> getFirstParamMapByName(String name) {
        EtsiUHeaderParamElement elem = this.getFirstParamElemByName(name);
        if (elem != null) {
            return elem.getParameterMap();
        }
        return null;
    }

    public EtsiUHeaderParamElement getFirstParamElemByName(String name) {
        for (EtsiUHeaderParamElement element : this) {
            Map<String, Object> elemMap = element.getParameterMap();
            if (!elemMap.containsKey(name)) continue;
            return element;
        }
        return null;
    }

    public List<EtsiUHeaderParamElement> getSublistUpToExcl(int index) {
        if (index == 0) {
            return Collections.emptyList();
        }
        if (index >= this.size()) {
            return this.headerParamElements;
        }
        ArrayList<EtsiUHeaderParamElement> sublist = new ArrayList<EtsiUHeaderParamElement>();
        for (int i = 0; i < index; ++i) {
            sublist.add(this.headerParamElements.get(i));
        }
        return sublist;
    }

    public List<EtsiUHeaderParamElement> getSublist(List<String> headerParamNames) {
        ArrayList<EtsiUHeaderParamElement> sublist = new ArrayList<EtsiUHeaderParamElement>();
        for (EtsiUHeaderParamElement headerElem : this) {
            for (String headerParamName : headerParamNames) {
                if (!headerElem.getParameterMap().containsKey(headerParamName)) continue;
                sublist.add(headerElem);
            }
        }
        return sublist;
    }

    public boolean containsNot(List<String> headerParamNames) {
        return this.getSublist(headerParamNames).isEmpty();
    }

    public List<EtsiUHeaderParamElement> getRefs() {
        return this.getSublist(rfsTstImprintHeaderParamNames);
    }

    public List<EtsiUHeaderParamElement> getSigTstsAndRefs() {
        return this.getSublist(sigRTstImprintHeaderParamNames);
    }

    public int count(String name) {
        return this.getSublist(Collections.singletonList(name)).size();
    }

    static {
        rfsTstImprintHeaderParamNames.addAll(rfsHeaderParamNames);
        sigRTstImprintHeaderParamNames.add("sigTst");
        sigRTstImprintHeaderParamNames.addAll(rfsHeaderParamNames);
    }
}

