/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta.svpgenerators;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.RevocationValuesType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValuesSvpGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationValuesSvpGenerator.class);
    private ObjectFactory svpFactory;
    private Function<RevocationValuesType, JAXBElement<RevocationValuesType>> svpFactoryCreateMethod;

    public RevocationValuesSvpGenerator(ObjectFactory svpFactory, Function<RevocationValuesType, JAXBElement<RevocationValuesType>> svpFactoryCreateMethod) {
        this.svpFactory = svpFactory;
        this.svpFactoryCreateMethod = svpFactoryCreateMethod;
    }

    public void generateSvpForAttachments(AdESSignature adesSignature, Collection<SignatureValidationDataAttachment<?>> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        RevocationValuesType revocationValuesType = new RevocationValuesType();
        revocationValuesType.setSigned(Boolean.valueOf(false));
        List revocationValues = revocationValuesType.getRevocationValue();
        for (SignatureValidationDataAttachment<?> ocspAttachment : attachments) {
            try {
                Object value = ocspAttachment.getValue();
                if (value instanceof OCSPResp) {
                    revocationValues.add(((OCSPResp)value).getEncoded());
                    continue;
                }
                if (!(value instanceof X509CRL)) continue;
                revocationValues.add(((X509CRL)value).getEncoded());
            }
            catch (Exception e) {
                LOG.error("Cannot get encoded ocsp response / crl", (Throwable)e);
            }
        }
        SignatureAttributesType signatureAttributes = adesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            adesSignature.setSignatureAttributes(signatureAttributes);
        }
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.svpFactoryCreateMethod.apply(revocationValuesType));
    }
}

