/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta.svpgenerators;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.validate.svp.CRLIDType;
import de.governikus.csl.validate.svp.OCSPIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.RevIDListType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationRefsSvpGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RevocationRefsSvpGenerator.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssX");
    private ObjectFactory svpFactory;
    private Function<RevIDListType, JAXBElement<RevIDListType>> svpFactoryCreateMethod;

    public RevocationRefsSvpGenerator(ObjectFactory svpFactory, Function<RevIDListType, JAXBElement<RevIDListType>> svpFactoryCreateMethod) {
        this.svpFactory = svpFactory;
        this.svpFactoryCreateMethod = svpFactoryCreateMethod;
    }

    public void generateSvpForAttachments(AdESSignature adesSignature, Map<String, Object> revRefsMap) {
        if (revRefsMap == null || revRefsMap.isEmpty()) {
            return;
        }
        RevIDListType revIDListType = new RevIDListType();
        revIDListType.setSigned(Boolean.valueOf(false));
        List crlOrOcspRevRefsList = revIDListType.getCRLIDOrOCSPID();
        for (Map.Entry<String, Object> revRefsMapEntry : revRefsMap.entrySet()) {
            String revRefsListType = revRefsMapEntry.getKey();
            Object revRefsListObj = revRefsMapEntry.getValue();
            if ("crlRefs".equals(revRefsListType)) {
                this.generateCrlRevRefsSvp(revRefsListObj, crlOrOcspRevRefsList);
                continue;
            }
            if (!"ocspRefs".equals(revRefsListType)) continue;
            this.generateOcspRevRefsSvp(revRefsListObj, crlOrOcspRevRefsList);
        }
        SignatureAttributesType signatureAttributes = adesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            adesSignature.setSignatureAttributes(signatureAttributes);
        }
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.svpFactoryCreateMethod.apply(revIDListType));
    }

    private String getStringFromMap(String key, Map<String, Object> map) {
        Object object;
        if (map.containsKey(key) && (object = map.get(key)) instanceof String) {
            return (String)object;
        }
        return null;
    }

    private void generateCrlRevRefsSvp(Object crlRevRefsListObj, List<Serializable> crlOrOcspRevRefsList) {
        if (!(crlRevRefsListObj instanceof List)) {
            return;
        }
        List<Object> crlRevRefsList = JsonWebSignatureHelper.parseJsonAsObjectList(crlRevRefsListObj);
        for (Object crlRefObj : crlRevRefsList) {
            if (!(crlRefObj instanceof Map)) continue;
            Map<String, Object> crlRef = JsonWebSignatureHelper.parseJsonAsMap(crlRefObj);
            String digAlgJws = this.getStringFromMap("digAlg", crlRef);
            String digVal = this.getStringFromMap("digVal", crlRef);
            if (digAlgJws == null || digVal == null) continue;
            CRLIDType crlIdType = new CRLIDType();
            crlIdType.setDigestMethod(DigestUtil.getDigestAlgorithmForJwsName(digAlgJws));
            crlIdType.setDigestValue(digVal.getBytes(StandardCharsets.UTF_8));
            crlOrOcspRevRefsList.add((Serializable)crlIdType);
        }
    }

    private void generateOcspRevRefsSvp(Object ocspRevRefsListObj, List<Serializable> crlOrOcspRevRefsList) {
        if (!(ocspRevRefsListObj instanceof List)) {
            return;
        }
        List<Object> ocspRevRefsList = JsonWebSignatureHelper.parseJsonAsObjectList(ocspRevRefsListObj);
        for (Object ocspRefObj : ocspRevRefsList) {
            OCSPIDType ocspRef;
            if (!(ocspRefObj instanceof Map) || (ocspRef = this.readOcspRef(ocspRefObj)) == null) continue;
            crlOrOcspRevRefsList.add((Serializable)ocspRef);
        }
    }

    private OCSPIDType readOcspRef(Object ocspRefObj) {
        Map<String, Object> ocspRef = JsonWebSignatureHelper.parseJsonAsMap(ocspRefObj);
        if (ocspRef.containsKey("ocspId")) {
            Object ocspIdObj = ocspRef.get("ocspId");
            if (!(ocspIdObj instanceof Map)) {
                return null;
            }
            Map<String, Object> ocspId = JsonWebSignatureHelper.parseJsonAsMap(ocspIdObj);
            OCSPIDType ocspIdType = new OCSPIDType();
            this.readProducedAt(ocspId, ocspIdType);
            this.readResponderId(ocspId, ocspIdType);
            return ocspIdType;
        }
        return null;
    }

    private void readProducedAt(Map<String, Object> ocspId, OCSPIDType ocspidType) {
        String dateStr;
        if (ocspId.containsKey("producedAt") && (dateStr = this.getStringFromMap("producedAt", ocspId)) != null) {
            try {
                ocspidType.setProducedAt(this.dateFormat.parse(dateStr));
            }
            catch (Exception e) {
                logger.warn("Cannot parse producedAt in ocsp reference as date", (Throwable)e);
            }
        }
    }

    private void readResponderId(Map<String, Object> ocspId, OCSPIDType ocspidType) {
        Object responderIdObj;
        if (ocspId.containsKey("responderId") && (responderIdObj = ocspId.get("responderId")) instanceof Map) {
            String byKeyVal;
            Map<String, Object> responderId = JsonWebSignatureHelper.parseJsonAsMap(responderIdObj);
            if (responderId.containsKey("byName")) {
                String byNameVal = this.getStringFromMap("byName", responderId);
                if (byNameVal != null) {
                    ocspidType.setResponderIDByName(byNameVal);
                }
            } else if (responderId.containsKey("byKey") && (byKeyVal = this.getStringFromMap("byKey", responderId)) != null) {
                ocspidType.setResponderIDByKey(byKeyVal.getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

