/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta.svpgenerators;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.CertificateValuesType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesSvpGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CertificatesSvpGenerator.class);
    private ObjectFactory svpFactory;
    private Function<CertificateValuesType, JAXBElement<CertificateValuesType>> svpFactoryCreateMethod;

    public CertificatesSvpGenerator(ObjectFactory svpFactory, Function<CertificateValuesType, JAXBElement<CertificateValuesType>> svpFactoryCreateMethod) {
        this.svpFactory = svpFactory;
        this.svpFactoryCreateMethod = svpFactoryCreateMethod;
    }

    public void generateSvpForAttachments(AdESSignature adesSignature, Collection<SignatureValidationDataAttachment<X509Certificate>> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        CertificateValuesType certificateValuesType = this.svpFactory.createCertificateValuesType();
        certificateValuesType.setSigned(Boolean.valueOf(false));
        List certificateValues = certificateValuesType.getCertificateValue();
        for (SignatureValidationDataAttachment<X509Certificate> certAttachment : attachments) {
            try {
                certificateValues.add(((X509Certificate)certAttachment.getValue()).getEncoded());
            }
            catch (Exception e) {
                LOG.error("Cannot get encoded certificate", (Throwable)e);
            }
        }
        SignatureAttributesType signatureAttributes = adesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            adesSignature.setSignatureAttributes(signatureAttributes);
        }
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.svpFactoryCreateMethod.apply(certificateValuesType));
    }
}

