/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta.svpgenerators;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;

public class CertificateRefsSvpGenerator {
    private ObjectFactory svpFactory;
    private Function<CertIDListType, JAXBElement<CertIDListType>> svpFactoryCreateMethod;

    public CertificateRefsSvpGenerator(ObjectFactory svpFactory, Function<CertIDListType, JAXBElement<CertIDListType>> svpFactoryCreateMethod) {
        this.svpFactory = svpFactory;
        this.svpFactoryCreateMethod = svpFactoryCreateMethod;
    }

    public void generateSvpForAttachments(AdESSignature adesSignature, List<Object> certRefs) {
        if (certRefs == null || certRefs.isEmpty()) {
            return;
        }
        CertIDListType certIDListType = this.svpFactory.createCertIDListType();
        certIDListType.setSigned(Boolean.valueOf(false));
        List certIDs = certIDListType.getCertID();
        for (Object certRef : certRefs) {
            if (!(certRef instanceof Map)) continue;
            CertIDType certIDType = new CertIDType();
            Map<String, Object> certRefMap = JsonWebSignatureHelper.parseJsonAsMap(certRef);
            String digAlgJws = (String)certRefMap.get("digAlg");
            String digVal = (String)certRefMap.get("digVal");
            String kid = null;
            if (certRefMap.containsKey("kid")) {
                kid = (String)certRefMap.get("kid");
                certIDType.setX509IssuerSerial(kid.getBytes(StandardCharsets.UTF_8));
            }
            certIDType.setDigestMethod(DigestUtil.getDigestAlgorithmForJwsName(digAlgJws));
            certIDType.setDigestValue(digVal.getBytes(StandardCharsets.UTF_8));
            certIDs.add(certIDType);
        }
        SignatureAttributesType signatureAttributes = adesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            adesSignature.setSignatureAttributes(signatureAttributes);
        }
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.svpFactoryCreateMethod.apply(certIDListType));
    }
}

