/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.headerparams.lta.svpgenerators.RevocationValuesSvpGenerator;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.JAdESLongTermValidationDataUtil;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValuesParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(RevocationValuesParser.class);
    private static final List<String> revocationValuesHeaderNames = Arrays.asList("rVals", "arVals");
    private RevocationValuesSvpGenerator rValsSvpGenerator;
    private RevocationValuesSvpGenerator arValsSvpGenerator;

    public RevocationValuesParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.rValsSvpGenerator = new RevocationValuesSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeRevocationValues(arg_0));
        this.arValsSvpGenerator = new RevocationValuesSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeAttributeRevocationValues(arg_0));
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        boolean parsed = false;
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object revValsMapObj = parameterMapEntry.getValue();
        for (String headerName : revocationValuesHeaderNames) {
            if (!headerName.equals(parameterName) || !(revValsMapObj instanceof Map)) continue;
            Map<String, Object> revoValsMap = JsonWebSignatureHelper.parseJsonAsMap(revValsMapObj);
            if ("rVals".equals(parameterName)) {
                List<SignatureValidationDataAttachment<?>> newCertRevocationValues = JAdESLongTermValidationDataUtil.addRevocationValues((BaseSignature)jadesSignature, revoValsMap);
                this.rValsSvpGenerator.generateSvpForAttachments(jadesSignature, newCertRevocationValues);
                parsed = true;
                continue;
            }
            List<SignatureValidationDataAttachment<?>> newAttrCertRevocationValues = JAdESLongTermValidationDataUtil.addRevocationValues((BaseSignature)jadesSignature, revoValsMap);
            this.arValsSvpGenerator.generateSvpForAttachments(jadesSignature, newAttrCertRevocationValues);
            parsed = true;
        }
        if (!parsed) {
            if (this.nextParser != null) {
                this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
            } else {
                logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
            }
        }
    }
}

