/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.headerparams.lta.svpgenerators.RevocationRefsSvpGenerator;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationRefsParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(RevocationRefsParser.class);
    private static final List<String> revocationValuesHeaderNames = Arrays.asList("rRefs", "arRefs");
    private RevocationRefsSvpGenerator rRefsSvpGenerator;
    private RevocationRefsSvpGenerator arRefsSvpGenerator;

    public RevocationRefsParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.rRefsSvpGenerator = new RevocationRefsSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeCompleteRevocationRefs(arg_0));
        this.arRefsSvpGenerator = new RevocationRefsSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeAttributeRevocationRefs(arg_0));
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        boolean parsed = false;
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object revRefsMapObj = parameterMapEntry.getValue();
        for (String headerName : revocationValuesHeaderNames) {
            if (!headerName.equals(parameterName) || !(revRefsMapObj instanceof Map)) continue;
            Map<String, Object> revRefsMap = JsonWebSignatureHelper.parseJsonAsMap(revRefsMapObj);
            if ("rRefs".equals(parameterName)) {
                this.rRefsSvpGenerator.generateSvpForAttachments(jadesSignature, revRefsMap);
                parsed = true;
                continue;
            }
            this.arRefsSvpGenerator.generateSvpForAttachments(jadesSignature, revRefsMap);
            parsed = true;
        }
        if (!parsed) {
            if (this.nextParser != null) {
                this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
            } else {
                logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
            }
        }
    }
}

