/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.headerparams.lta.svpgenerators.CertificatesSvpGenerator;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.JAdESLongTermValidationDataUtil;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CertificatesParser.class);
    private static final List<String> certificateValuesHeaderNames = Arrays.asList("xVals", "axVals");
    private CertificatesSvpGenerator xValsSvpGenerator;
    private CertificatesSvpGenerator axValsSvpGenerator;

    public CertificatesParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.xValsSvpGenerator = new CertificatesSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeCertificateValues(arg_0));
        this.axValsSvpGenerator = new CertificatesSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeAttrAuthoritiesCertValues(arg_0));
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        boolean parsed = false;
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object certListObj = parameterMapEntry.getValue();
        for (String headerName : certificateValuesHeaderNames) {
            if (!headerName.equals(parameterName) || !(certListObj instanceof List)) continue;
            List<Object> certList = JsonWebSignatureHelper.parseJsonAsObjectList(certListObj);
            if ("xVals".equals(parameterName)) {
                Set<SignatureValidationDataAttachment<X509Certificate>> newCertificates = JAdESLongTermValidationDataUtil.addCertificates((BaseSignature)jadesSignature, certList);
                this.xValsSvpGenerator.generateSvpForAttachments(jadesSignature, newCertificates);
                parsed = true;
                continue;
            }
            Set<SignatureValidationDataAttachment<X509Certificate>> newAttrCertificates = JAdESLongTermValidationDataUtil.addCertificates((BaseSignature)jadesSignature, certList);
            this.axValsSvpGenerator.generateSvpForAttachments(jadesSignature, newAttrCertificates);
            parsed = true;
        }
        if (!parsed) {
            if (this.nextParser != null) {
                this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
            } else {
                logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
            }
        }
    }
}

