/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams.lta;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.headerparams.lta.svpgenerators.CertificateRefsSvpGenerator;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.Base64Util;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validation.CertificateReferenceImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateRefsParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CertificateRefsParser.class);
    private static final Base64Util base64Util = new Base64Util();
    private static final List<String> certificateRefsHeaderNames = Arrays.asList("xRefs", "axRefs");
    private CertificateRefsSvpGenerator xRefsSvpGenerator;
    private CertificateRefsSvpGenerator axRefsSvpGenerator;

    public CertificateRefsParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.xRefsSvpGenerator = new CertificateRefsSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeCompleteCertificateRefs(arg_0));
        this.axRefsSvpGenerator = new CertificateRefsSvpGenerator(svpFactory, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeAttributeCertificateRefs(arg_0));
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        boolean parsed = false;
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object certRefs = parameterMapEntry.getValue();
        for (String headerName : certificateRefsHeaderNames) {
            if (!headerName.equals(parameterName) || !(certRefs instanceof List)) continue;
            List<Object> certRefsList = JsonWebSignatureHelper.parseJsonAsObjectList(certRefs);
            if ("xRefs".equals(parameterName)) {
                this.xRefsSvpGenerator.generateSvpForAttachments(jadesSignature, certRefsList);
                this.addCertRefs(jadesSignature);
                parsed = true;
                continue;
            }
            this.axRefsSvpGenerator.generateSvpForAttachments(jadesSignature, certRefsList);
            parsed = true;
        }
        if (!parsed) {
            if (this.nextParser != null) {
                this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
            } else {
                logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
            }
        }
    }

    private List<CertificateReference> getCompleteCertificateReferences(JAdESSignature jadesSignature) {
        ArrayList completeCertificateReferences = jadesSignature.getCompleteCertificateReferences();
        if (completeCertificateReferences == null) {
            completeCertificateReferences = new ArrayList();
            jadesSignature.setCompleteCertificateReferences(completeCertificateReferences);
        }
        return completeCertificateReferences;
    }

    private void addCertRefs(JAdESSignature jadesSignature) {
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes != null) {
            List<CertificateReference> completeCertificateReferences = this.getCompleteCertificateReferences(jadesSignature);
            List svpElems = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            for (JAXBElement svpElem : svpElems) {
                AttributeBaseType attributeBaseType = (AttributeBaseType)svpElem.getValue();
                if (!(attributeBaseType instanceof CertIDListType)) continue;
                CertIDListType certIDListType = (CertIDListType)attributeBaseType;
                for (CertIDType certId : certIDListType.getCertID()) {
                    BigInteger issuerSerialNr = null;
                    String issuerName = null;
                    IssuerSerial issuerSerial = this.getIssuerSerial(certId);
                    if (issuerSerial != null) {
                        issuerName = issuerSerial.getIssuer().getDisplayName();
                        issuerSerialNr = issuerSerial.getSerialnumber().getValue();
                    }
                    completeCertificateReferences.add((CertificateReference)new CertificateReferenceImpl((DigestAlgorithm)certId.getDigestMethod(), base64Util.decode(certId.getDigestValue()), issuerName, issuerSerialNr, null));
                }
            }
        }
    }

    private IssuerSerial getIssuerSerial(CertIDType certId) {
        byte[] x509IssuerSerialBytes = certId.getX509IssuerSerial();
        if (x509IssuerSerialBytes != null) {
            try {
                return new IssuerSerial(Run.create((Source)new BSource(base64Util.decode(x509IssuerSerialBytes))));
            }
            catch (Exception e) {
                logger.error("Cannot parse issuer serial", (Throwable)e);
            }
        }
        return null;
    }
}

