/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.jades.JAdESCertificateReference;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateSHA256DigestParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(X509CertificateSHA256DigestParser.class);
    private DigestAlgorithm sha256Algo = AlgorithmService.getDigestForJCAName((String)"SHA-256");

    public X509CertificateSHA256DigestParser(ObjectFactory svpFactory) throws CoreException {
        super(svpFactory);
        if (this.sha256Algo == null) {
            throw new CoreException("Algorithm SHA-256 not found");
        }
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("x5t#S256".equals(parameterName)) {
            if (parameterValue instanceof String) {
                String certS256Digest = (String)parameterValue;
                List<CertificateReference> signCertRefs = DigestUtil.getSignCertRefs(jadesSignature);
                JAdESCertificateReference certRef = new JAdESCertificateReference("x5t#S256", this.sha256Algo, Base64.getUrlDecoder().decode(certS256Digest));
                signCertRefs.add((CertificateReference)certRef);
                DigestUtil.addSigningCertificateReferenceToSvp(jadesSignature, certRef);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }
}

