/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.jades.JAdESCertificateReference;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateNonSHA256DigestParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(X509CertificateNonSHA256DigestParser.class);

    public X509CertificateNonSHA256DigestParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    protected String getHeaderParamName() {
        return "x5t#o";
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("x5t#o".equals(parameterName) && parameterValue instanceof Map) {
            Map<String, Object> digAlgAndVal = JsonWebSignatureHelper.parseJsonAsMap(parameterValue);
            Object digAlg = digAlgAndVal.get("digAlg");
            Object digVal = digAlgAndVal.get("digVal");
            if (digAlg instanceof String && digVal instanceof String) {
                DigestAlgorithm digestAlgo = this.getDigestAlgorithm(digAlg);
                JAdESCertificateReference certRef = new JAdESCertificateReference(this.getHeaderParamName(), digestAlgo, Base64.getUrlDecoder().decode((String)digVal));
                if (digestAlgo == null) {
                    certRef.setUnknownAlgoName((String)digAlg);
                }
                List<CertificateReference> signCertRefs = DigestUtil.getSignCertRefs(jadesSignature);
                signCertRefs.add((CertificateReference)certRef);
                DigestUtil.addSigningCertificateReferenceToSvp(jadesSignature, certRef);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private DigestAlgorithm getDigestAlgorithm(Object digAlg) {
        if (digAlg instanceof String) {
            String algName = (String)digAlg;
            if ((algName = JsonWebSignatureHelper.mapJWSAlgoToJCA(algName)) != null) {
                return AlgorithmService.getDigestForJCAName((String)algName);
            }
        }
        return null;
    }
}

