/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.X509CertificateNonSHA256DigestParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateAnyDigestListParser
extends X509CertificateNonSHA256DigestParser {
    private static final Logger logger = LoggerFactory.getLogger(X509CertificateAnyDigestListParser.class);

    public X509CertificateAnyDigestListParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    protected String getHeaderParamName() {
        return "sigX5ts";
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if (this.getHeaderParamName().equals(parameterName) && parameterValue instanceof List) {
            List<Object> signCertDigestInfos = JsonWebSignatureHelper.parseJsonAsObjectList(parameterValue);
            if (!signCertDigestInfos.isEmpty()) {
                super.parseHeaderParameter("x5t#o", signCertDigestInfos.get(0), jadesSignature);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }
}

