/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.JAdESLongTermValidationDataUtil;
import de.governikus.csl.jades.util.TimestampValidationData;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampValidationDataParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(TimestampValidationDataParser.class);

    public TimestampValidationDataParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object tstVdObj = parameterMapEntry.getValue();
        if ("tstVD".equals(parameterName) && tstVdObj instanceof Map) {
            Map<String, Object> tstVdMap = JsonWebSignatureHelper.parseJsonAsMap(tstVdObj);
            Set<SignatureValidationDataAttachment<X509Certificate>> attachedCerts = null;
            List<SignatureValidationDataAttachment<OCSPResp>> attachedOcsps = null;
            List<SignatureValidationDataAttachment<CRL>> attachedCrls = null;
            attachedCerts = this.getCertAttachments(tstVdMap);
            if (tstVdMap.containsKey("rVals")) {
                Map<String, Object> rValsMap = JsonWebSignatureHelper.parseJsonAsMap(tstVdMap.get("rVals"));
                attachedOcsps = this.getOcspValueAttachments(rValsMap);
                attachedCrls = this.getCrlAttachments(rValsMap);
            }
            this.addToSignaturesTstVdList(parameterElement.getEtsiUIndex(), jadesSignature, attachedCerts, attachedOcsps, attachedCrls);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private Set<SignatureValidationDataAttachment<X509Certificate>> getCertAttachments(Map<String, Object> tstVdMap) {
        Set<SignatureValidationDataAttachment<X509Certificate>> attachedCerts = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        if (tstVdMap.containsKey("xVals")) {
            List<Object> certAttachmentsList = JsonWebSignatureHelper.parseJsonAsObjectList(tstVdMap.get("xVals"));
            attachedCerts = JAdESLongTermValidationDataUtil.parseCertificates(certAttachmentsList);
        }
        return attachedCerts;
    }

    private List<SignatureValidationDataAttachment<OCSPResp>> getOcspValueAttachments(Map<String, Object> rValsMap) {
        Object ocspValsListObj;
        List<SignatureValidationDataAttachment<OCSPResp>> attachedOcsps = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
        if (rValsMap.containsKey("ocspVals") && (ocspValsListObj = rValsMap.get("ocspVals")) instanceof List) {
            List<Object> ocspValueAttachmentsList = JsonWebSignatureHelper.parseJsonAsObjectList(ocspValsListObj);
            attachedOcsps = JAdESLongTermValidationDataUtil.parseOcspRevocationValues(ocspValueAttachmentsList);
        }
        return attachedOcsps;
    }

    private List<SignatureValidationDataAttachment<CRL>> getCrlAttachments(Map<String, Object> rValsMap) {
        Object crlValsListObj;
        List<SignatureValidationDataAttachment<CRL>> attachedCrls = new ArrayList<SignatureValidationDataAttachment<CRL>>();
        if (rValsMap.containsKey("crlVals") && (crlValsListObj = rValsMap.get("crlVals")) instanceof List) {
            List<Object> crlAttachmentsList = JsonWebSignatureHelper.parseJsonAsObjectList(crlValsListObj);
            attachedCrls = JAdESLongTermValidationDataUtil.parseCrlRevocationValues(crlAttachmentsList);
        }
        return attachedCrls;
    }

    private void addToSignaturesTstVdList(int tstVDEtsiUIndex, JAdESSignature jadesSignature, Set<SignatureValidationDataAttachment<X509Certificate>> attachedCerts, List<SignatureValidationDataAttachment<OCSPResp>> attachedOcsps, List<SignatureValidationDataAttachment<CRL>> attachedCrls) {
        if (attachedCerts != null && !attachedCerts.isEmpty() || attachedOcsps != null && !attachedOcsps.isEmpty() || attachedCrls != null && !attachedCrls.isEmpty()) {
            TimestampValidationData newTimestampValidationData;
            List<TimestampValidationData> timestampValidationDataList = jadesSignature.getTimestampValidationDataList();
            if (timestampValidationDataList.isEmpty()) {
                newTimestampValidationData = new TimestampValidationData(tstVDEtsiUIndex, attachedCerts, attachedOcsps, attachedCrls);
            } else {
                TimestampValidationData lastTimestampValidationData = timestampValidationDataList.get(timestampValidationDataList.size() - 1);
                newTimestampValidationData = new TimestampValidationData(tstVDEtsiUIndex, lastTimestampValidationData, attachedCerts, attachedOcsps, attachedCrls);
            }
            timestampValidationDataList.add(newTimestampValidationData);
        }
    }
}

