/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.RoleDetailsType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignerRoleType;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerAttributesParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(SignerAttributesParser.class);
    private static final String CERTIFIED = "certified";
    private static final String X509_ATTR_CERT_KEY = "x509AttrCert";
    private static final String OTHER_ATTR_CERT_KEY = "otherAttrCert";
    private static final String ROLE_PARSE_ERR_MSG = "Could not parse role in attribute certificate";

    public SignerAttributesParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object srAtsObj, JAdESSignature jadesSignature) {
        if ("srAts".equals(parameterName) && srAtsObj instanceof Map) {
            Map<String, Object> srAtsMap = JsonWebSignatureHelper.parseJsonAsMap(srAtsObj);
            this.processSignerAttributesMap(jadesSignature, srAtsMap);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, srAtsObj, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void processSignerAttributesMap(JAdESSignature jadesSignature, Map<String, Object> srAtsMap) {
        Object certifiedAttrListObj;
        List<Object> certifiedAttrList;
        Set<AttributeCertificate> attrCertSet;
        if (srAtsMap.containsKey(CERTIFIED) && !(attrCertSet = this.getAttributeCertificates(certifiedAttrList = JsonWebSignatureHelper.parseJsonAsObjectList(certifiedAttrListObj = srAtsMap.get(CERTIFIED)))).isEmpty()) {
            jadesSignature.setAttributeCertificates(attrCertSet);
            this.addAttrCertsToSvp(jadesSignature, attrCertSet);
        }
    }

    private Set<AttributeCertificate> getAttributeCertificates(List<Object> certifiedAttrList) {
        HashSet<AttributeCertificate> attrCertSet = new HashSet<AttributeCertificate>();
        for (Object certifiedAttrsObj : certifiedAttrList) {
            Map<String, Object> certifiedAttrsMap = JsonWebSignatureHelper.parseJsonAsMap(certifiedAttrsObj);
            AttributeCertificate attributeCertificate = this.readAttributeCertificate(certifiedAttrsMap);
            if (attributeCertificate == null) continue;
            attrCertSet.add(attributeCertificate);
        }
        return attrCertSet;
    }

    private AttributeCertificate readAttributeCertificate(Map<String, Object> certifiedAttrsMap) {
        if (certifiedAttrsMap.containsKey(X509_ATTR_CERT_KEY)) {
            String b64AttrCert = (String)certifiedAttrsMap.get(X509_ATTR_CERT_KEY);
            try {
                byte[] attrCert = Base64.getDecoder().decode(b64AttrCert);
                return AttributeCertificate.getInstance((Object)attrCert);
            }
            catch (Exception e) {
                logger.debug("Cannot parse attribute certificate in jades header");
            }
        } else if (certifiedAttrsMap.containsKey(OTHER_ATTR_CERT_KEY)) {
            logger.warn("Ignoring non x509 attribute certificate");
        }
        return null;
    }

    private void addAttrCertsToSvp(JAdESSignature jadesSignature, Set<AttributeCertificate> attrCertSet) {
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributes);
        }
        SignerRoleType signerRoleType = this.svpFactory.createSignerRoleType();
        signerRoleType.setSigned(Boolean.valueOf(true));
        this.processAttrCerts(attrCertSet, signerRoleType.getRoleDetails());
        if (!signerRoleType.getRoleDetails().isEmpty()) {
            List signatureAttributesList = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            signatureAttributesList.add(this.svpFactory.createSignatureAttributesTypeSignerRole(signerRoleType));
        }
    }

    private void processAttrCerts(Set<AttributeCertificate> attrCertSet, List<RoleDetailsType> roleDetailList) {
        for (AttributeCertificate attrCert : attrCertSet) {
            ASN1Sequence attributes = attrCert.getAcinfo().getAttributes();
            for (int attrIndex = 0; attrIndex < attributes.size(); ++attrIndex) {
                ASN1Sequence attrSeq = ASN1Sequence.getInstance((Object)attributes.getObjectAt(attrIndex));
                RoleDetailsType roleDetailsType = this.svpFactory.createRoleDetailsType();
                for (int valueSetindex = 0; valueSetindex < attrSeq.size(); ++valueSetindex) {
                    ASN1Encodable seqElem = attrSeq.getObjectAt(valueSetindex);
                    if (seqElem instanceof ASN1ObjectIdentifier) {
                        roleDetailsType.setEndorsement(seqElem.toString());
                        continue;
                    }
                    if (!(seqElem instanceof ASN1Set)) continue;
                    roleDetailsType.setRole(this.getStringFromValueSet((ASN1Set)seqElem));
                }
                roleDetailList.add(roleDetailsType);
            }
        }
    }

    private String getStringFromValueSet(ASN1Set set) {
        ASN1Encodable value = ASN1Set.getInstance((Object)set).getObjectAt(0);
        if (value instanceof ASN1String) {
            return value.toString();
        }
        if (value instanceof ASN1Sequence) {
            ASN1Sequence valueSeq = ASN1Sequence.getInstance((Object)value);
            if ((value = valueSeq.getObjectAt(0)) instanceof ASN1TaggedObject) {
                value = ((ASN1TaggedObject)value).getBaseObject();
            }
            return value.toString();
        }
        logger.error(ROLE_PARSE_ERR_MSG);
        return ROLE_PARSE_ERR_MSG;
    }
}

