/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.TimestampParserUtil;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureTimestampParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(SignatureTimestampParser.class);
    private TimestampParserUtil timestampParserUtil = new TimestampParserUtil();

    public SignatureTimestampParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.timestampParserUtil.setSvpFactory(svpFactory);
        this.timestampParserUtil.setMaxTokenListSize(0);
        this.timestampParserUtil.setDigestGetter(this::getDigestStreamProvider);
        this.timestampParserUtil.setSvpFactoryCreateMethod(arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeSignatureTimeStamp(arg_0));
        this.timestampParserUtil.setSignedHeaderParam(false);
        this.timestampParserUtil.setOnlyCheckIndex0ForTstVd(false);
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object tstContentObj = parameterMapEntry.getValue();
        if ("sigTst".equals(parameterName) && tstContentObj instanceof Map) {
            Map<String, Object> tstContent = JsonWebSignatureHelper.parseJsonAsMap(tstContentObj);
            this.timestampParserUtil.setSignatureTimestampSetter(arg_0 -> ((JAdESSignature)jadesSignature).setSignatureTimestamps(arg_0));
            this.timestampParserUtil.setTimestampIndex(parameterElement.getEtsiUIndex());
            this.timestampParserUtil.processTimestampMap(jadesSignature, tstContent);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private StreamProvider getDigestStreamProvider(JAdESSignature jadesSignature) {
        return new ByteArrayStreamProvider(Base64.getUrlEncoder().withoutPadding().encode(jadesSignature.getSignatureValue()));
    }
}

