/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignerLocationType;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureProductionPlaceParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(SignatureProductionPlaceParser.class);
    private static final String MAP_KEY_ADDRESS_COUNTRY = "addressCountry";
    private static final String MAP_KEY_ADDRESS_LOCALITY = "addressLocality";
    private static final String MAP_KEY_ADDRESS_REGION = "addressRegion";
    private static final String MAP_KEY_POST_OFFICE_BOX_NUMBER = "postOfficeBoxNumber";
    private static final String MAP_KEY_POSTAL_CODE = "postalCode";
    private static final String MAP_KEY_STREET_ADDRESS = "streetAddress";

    public SignatureProductionPlaceParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("sigPl".equals(parameterName)) {
            if (parameterValue instanceof Map) {
                Map postalAddress = (Map)parameterValue;
                SignerLocationType signerLocation = this.svpFactory.createSignerLocationType();
                signerLocation.setSigned(Boolean.TRUE);
                this.mapAddressParts(postalAddress, signerLocation);
                JAXBElement signerLocationElem = this.svpFactory.createSignatureAttributesTypeSignerLocation(signerLocation);
                SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
                if (signatureAttributes == null) {
                    signatureAttributes = this.svpFactory.createSignatureAttributesType();
                    jadesSignature.setSignatureAttributes(signatureAttributes);
                }
                signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signerLocationElem);
            } else {
                logger.warn("Failed to parse sigPl header parameter value as map.");
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void mapAddressParts(Map<String, String> postalAddress, SignerLocationType signerLocation) {
        if (postalAddress.containsKey(MAP_KEY_ADDRESS_COUNTRY)) {
            signerLocation.setCountryName(postalAddress.get(MAP_KEY_ADDRESS_COUNTRY));
        }
        if (postalAddress.containsKey(MAP_KEY_ADDRESS_LOCALITY)) {
            signerLocation.setLocalityName(postalAddress.get(MAP_KEY_ADDRESS_LOCALITY));
        }
        List address = signerLocation.getAddress();
        if (postalAddress.containsKey(MAP_KEY_ADDRESS_REGION)) {
            address.add(postalAddress.get(MAP_KEY_ADDRESS_REGION));
        }
        if (postalAddress.containsKey(MAP_KEY_POST_OFFICE_BOX_NUMBER)) {
            address.add(postalAddress.get(MAP_KEY_POST_OFFICE_BOX_NUMBER));
        }
        if (postalAddress.containsKey(MAP_KEY_POSTAL_CODE)) {
            address.add(postalAddress.get(MAP_KEY_POSTAL_CODE));
        }
        if (postalAddress.containsKey(MAP_KEY_STREET_ADDRESS)) {
            address.add(postalAddress.get(MAP_KEY_STREET_ADDRESS));
        }
    }
}

