/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESOID;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.JAdESSignaturePolicyId;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.util.HeaderParameterFactory;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SigPolicyIdentifierType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignaturePolicyIdParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(SignaturePolicyIdParser.class);
    private HeaderParameterFactory headerParamFac = new HeaderParameterFactory();

    public SignaturePolicyIdParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("sigPId".equals(parameterName)) {
            JAdESSignaturePolicyId jadesSignaturePolicyId = this.headerParamFac.parseSignaturePolicyId(parameterValue);
            if (jadesSignaturePolicyId != null) {
                jadesSignature.setSignaturePolicyId(jadesSignaturePolicyId);
                this.addToSvp(jadesSignature);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void addToSvp(JAdESSignature jadesSignature) {
        SigPolicyIdentifierType sigPolicyIdentifierType = this.svpFactory.createSigPolicyIdentifierType();
        sigPolicyIdentifierType.setSigned(Boolean.TRUE);
        JAdESSignaturePolicyId jadesSignaturePolicyId = jadesSignature.getSignaturePolicyId();
        JAdESOID oid = jadesSignaturePolicyId.getSignaturePolicyId();
        if (oid != null) {
            sigPolicyIdentifierType.setSigPolicyId(oid.getId());
        }
        JAXBElement sigPolIdElem = this.svpFactory.createSignatureAttributesTypeSignaturePolicyIdentifier(sigPolicyIdentifierType);
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributes);
        }
        signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(sigPolIdElem);
    }
}

