/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.EtsiUHeaderParams;
import de.governikus.csl.jades.json.JsonCanonicalizerUtil;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.TimestampParserUtil;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.util.ConcatenatedDocumentInputStreamProvider;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigValSigTstAndRefsTimestampParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(SigValSigTstAndRefsTimestampParser.class);
    private JsonCanonicalizerUtil canonicUtil = new JsonCanonicalizerUtil();
    private TimestampParserUtil timestampParserUtil = new TimestampParserUtil();

    public SigValSigTstAndRefsTimestampParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.timestampParserUtil.setSvpFactory(svpFactory);
        this.timestampParserUtil.setMaxTokenListSize(0);
        this.timestampParserUtil.setDigestGetter(this::getDigestStreamProvider);
        this.timestampParserUtil.setSignatureTimestampSetter(null);
        this.timestampParserUtil.setSvpFactoryCreateMethod(arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeSigAndRefsTimeStamp(arg_0));
        this.timestampParserUtil.setSignedHeaderParam(false);
        this.timestampParserUtil.setOnlyCheckIndex0ForTstVd(false);
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object tstContentObj = parameterMapEntry.getValue();
        if ("sigRTst".equals(parameterName) && tstContentObj instanceof Map) {
            Map<String, Object> tstContent = JsonWebSignatureHelper.parseJsonAsMap(tstContentObj);
            this.timestampParserUtil.setTimestampIndex(parameterElement.getEtsiUIndex());
            this.timestampParserUtil.processTimestampMap(jadesSignature, tstContent);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private StreamProvider getDigestStreamProvider(JAdESSignature jadesSignature) {
        ArrayList<ByteArrayDocument> digestByteList = new ArrayList<ByteArrayDocument>();
        digestByteList.add(new ByteArrayDocument(Base64.getUrlEncoder().withoutPadding().encode(jadesSignature.getSignatureValue())));
        EtsiUHeaderParams etsiUHeaderParams = jadesSignature.getEtsiUHeaderParams();
        for (EtsiUHeaderParamElement paramElem : etsiUHeaderParams.getSigTstsAndRefs()) {
            try {
                digestByteList.add(new ByteArrayDocument(paramElem.getImprintBytes(this.canonicUtil)));
            }
            catch (Exception e) {
                logger.error("Error during imprint building for sigRTst header parameter", (Throwable)e);
            }
        }
        return new ConcatenatedDocumentInputStreamProvider(digestByteList);
    }
}

