/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESDocument;
import de.governikus.csl.jades.JAdESParser;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.UnsignedHeaderParameterParser;
import de.governikus.csl.jades.json.EtsiUConformityException;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.util.Base64Util;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.validate.svp.CounterSignatureType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignatureReferenceType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterSignatureParser
extends UnsignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CounterSignatureParser.class);
    private final JAdESParser jadesParser;
    private final Base64Util base64Util;
    private final MessageDigest sha256Digest;

    public CounterSignatureParser(ObjectFactory svpFactory, JAdESParser jadesParser, Base64Util base64Util) {
        super(svpFactory);
        this.jadesParser = jadesParser;
        this.base64Util = base64Util;
        try {
            this.sha256Digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to initialize SHA-256 MessageDigest object.", e);
        }
    }

    @Override
    public void parseHeaderParameter(EtsiUHeaderParamElement parameterElement, JAdESSignature jadesSignature) {
        Map.Entry<String, Object> parameterMapEntry = this.getParameterNameAndValue(parameterElement);
        if (parameterMapEntry == null) {
            return;
        }
        String parameterName = parameterMapEntry.getKey();
        Object parameterValue = parameterMapEntry.getValue();
        if ("cSig".equals(parameterName)) {
            byte[] jsonBytes = parameterValue.toString().getBytes(StandardCharsets.UTF_8);
            this.createCounterSignatureStructureForValidation(jadesSignature, jsonBytes);
            this.createSignatureAttribute(jadesSignature, jsonBytes);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterElement, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void createSignatureAttribute(JAdESSignature jadesSignature, byte[] counterSignatureBytes) {
        byte[] hashOverCounterSignature = this.sha256Digest.digest(counterSignatureBytes);
        SignatureReferenceType sigReference = this.svpFactory.createSignatureReferenceType();
        sigReference.setDigestValue(hashOverCounterSignature);
        sigReference.setDigestMethod(DigestUtil.getDigestAlgorithmForJcaName("SHA-256"));
        CounterSignatureType counterSignatureType = this.svpFactory.createCounterSignatureType();
        counterSignatureType.setSigned(Boolean.FALSE);
        List counterSignatureList = counterSignatureType.getCounterSignature();
        counterSignatureList.add(sigReference);
        SignatureAttributesType signatureAttributesObj = jadesSignature.getSignatureAttributes();
        if (signatureAttributesObj == null) {
            signatureAttributesObj = this.svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributesObj);
        }
        JAXBElement counterSignatureElem = this.svpFactory.createSignatureAttributesTypeCounterSignature(counterSignatureType);
        List sigAttrsList = signatureAttributesObj.getSigningTimeOrSigningCertificateOrDataObjectFormat();
        sigAttrsList.add(counterSignatureElem);
    }

    private void createCounterSignatureStructureForValidation(JAdESSignature jadesSignature, byte[] counterSignatureBytes) {
        byte[] enhancedSignature = this.enhanceSignatureWithPayload(counterSignatureBytes, jadesSignature.getSignatureValue());
        ByteArrayDocument jadesDocument = new ByteArrayDocument(enhancedSignature);
        SimpleSignedData signedData = new SimpleSignedData((Document)jadesDocument);
        try {
            JAdESDocument loadedJadesDocument = this.jadesParser.loadDocument((SignedData)signedData);
            List counterSignatures = loadedJadesDocument.getSignatures();
            jadesSignature.setCounterSignatures(Collections.unmodifiableList(counterSignatures));
        }
        catch (EtsiUConformityException | CoreException | IOException | GeneralSecurityException e) {
            logger.warn("Counter Signature Header Parameter (cSig) could not be processed. The counter signature will be ignored.", e);
        }
    }

    private byte[] enhanceSignatureWithPayload(byte[] counterSignatureBytes, byte[] signatureValue) {
        String b64UrlEncodedParentSignature = this.base64Util.encodeUrlSafeWithoutPadding(signatureValue);
        String counterSignatureValue = new String(counterSignatureBytes, StandardCharsets.UTF_8);
        String enhancedSignature = counterSignatureValue.contains("signature") ? counterSignatureValue.replaceFirst("\\{", "\\{\"payload\":\"" + b64UrlEncodedParentSignature + "\",") : counterSignatureValue.replaceFirst("\\.", "\\." + b64UrlEncodedParentSignature);
        return enhancedSignature.getBytes(StandardCharsets.UTF_8);
    }
}

