/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.TimestampParserUtil;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTimestampParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(ContentTimestampParser.class);
    private TimestampParserUtil timestampParserUtil = new TimestampParserUtil();

    public ContentTimestampParser(ObjectFactory svpFactory) {
        super(svpFactory);
        this.timestampParserUtil.setSvpFactory(svpFactory);
        this.timestampParserUtil.setMaxTokenListSize(1);
        this.timestampParserUtil.setDigestGetter(this::getDigestStreamProvider);
        this.timestampParserUtil.setSvpFactoryCreateMethod(arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeAllDataObjectsTimeStamp(arg_0));
        this.timestampParserUtil.setSignedHeaderParam(true);
        this.timestampParserUtil.setOnlyCheckIndex0ForTstVd(true);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object tstContainer, JAdESSignature jadesSignature) {
        if ("adoTst".equals(parameterName) && tstContainer instanceof Map) {
            Map<String, Object> tstContMap = JsonWebSignatureHelper.parseJsonAsMap(tstContainer);
            this.timestampParserUtil.setSignatureTimestampSetter(arg_0 -> ((JAdESSignature)jadesSignature).setSignedDataTimestamps(arg_0));
            this.timestampParserUtil.processTimestampMap(jadesSignature, tstContMap);
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, tstContainer, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private StreamProvider getDigestStreamProvider(JAdESSignature jadesSignature) {
        return new ByteArrayStreamProvider(jadesSignature.getJwsPayload());
    }
}

