/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.validate.svp.CommitmentType;
import de.governikus.csl.validate.svp.CommitmentTypeIndicationType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitmentTypeIndicationParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CommitmentTypeIndicationParser.class);
    private static final String MAP_KEY_COMM_ID = "commId";
    private static final String MAP_KEY_ID = "id";

    public CommitmentTypeIndicationParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("srCms".equals(parameterName)) {
            List<Object> parameterValueList = JsonWebSignatureHelper.parseJsonAsObjectList(parameterValue);
            for (Object singleCommitmentObject : parameterValueList) {
                this.processSingleCommitment(jadesSignature, singleCommitmentObject);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void processSingleCommitment(JAdESSignature jadesSignature, Object singleCommitmentObject) {
        Map<String, Object> singleCommitmentMap = JsonWebSignatureHelper.parseJsonAsMap(singleCommitmentObject);
        if (singleCommitmentMap.containsKey(MAP_KEY_COMM_ID)) {
            Object oidObject = singleCommitmentMap.get(MAP_KEY_COMM_ID);
            Map<String, Object> oidMap = JsonWebSignatureHelper.parseJsonAsMap(oidObject);
            String commitmentTypeIndicationId = oidMap.get(MAP_KEY_ID).toString();
            CommitmentType commitmentType = this.createCommitmentTypeFromId(commitmentTypeIndicationId);
            CommitmentTypeIndicationType svpCommitmentIndicationType = this.svpFactory.createCommitmentTypeIndicationType();
            svpCommitmentIndicationType.setSigned(Boolean.TRUE);
            svpCommitmentIndicationType.setCommitment(commitmentType);
            JAXBElement commitmentTypeInidicationElem = this.svpFactory.createSignatureAttributesTypeCommitmentTypeIndication(svpCommitmentIndicationType);
            SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
            if (signatureAttributes == null) {
                signatureAttributes = this.svpFactory.createSignatureAttributesType();
                jadesSignature.setSignatureAttributes(signatureAttributes);
            }
            List signatureAttributesList = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            signatureAttributesList.add(commitmentTypeInidicationElem);
        } else {
            logger.warn("CommitmentTypeIndication header parameter (srCms) does not contain the required 'commId' parameter.");
        }
    }

    private CommitmentType createCommitmentTypeFromId(String commitmentTypeIndicationId) {
        CommitmentType commitmentType = this.createCommitmentTypeFromUri(commitmentTypeIndicationId);
        if (commitmentType == null) {
            commitmentType = this.createCommitmentTypeFromURN(commitmentTypeIndicationId);
        }
        return commitmentType;
    }

    private CommitmentType createCommitmentTypeFromURN(String commitmentTypeIndicationId) {
        String lowerCaseId = commitmentTypeIndicationId.toLowerCase(Locale.ENGLISH);
        CommitmentType commitmentType = null;
        switch (lowerCaseId) {
            case "urn:oid:1.2.840.113549.1.9.16.6.1": {
                commitmentType = CommitmentType.PROOF_OF_ORIGIN;
                break;
            }
            case "urn:oid:1.2.840.113549.1.9.16.6.2": {
                commitmentType = CommitmentType.PROOF_OF_RECEIPT;
                break;
            }
            case "urn:oid:1.2.840.113549.1.9.16.6.3": {
                commitmentType = CommitmentType.PROOF_OF_DELIVERY;
                break;
            }
            case "urn:oid:1.2.840.113549.1.9.16.6.4": {
                commitmentType = CommitmentType.PROOF_OF_SENDER;
                break;
            }
            case "urn:oid:1.2.840.113549.1.9.16.6.5": {
                commitmentType = CommitmentType.PROOF_OF_APPROVAL;
                break;
            }
            case "urn:oid:1.2.840.113549.1.9.16.6.6": {
                commitmentType = CommitmentType.PROOF_OF_CREATION;
            }
        }
        return commitmentType;
    }

    private CommitmentType createCommitmentTypeFromUri(String commitmentTypeIndicationId) {
        CommitmentType commitmentType = null;
        switch (commitmentTypeIndicationId) {
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfOrigin": {
                commitmentType = CommitmentType.PROOF_OF_ORIGIN;
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfReceipt": {
                commitmentType = CommitmentType.PROOF_OF_RECEIPT;
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfDelivery": {
                commitmentType = CommitmentType.PROOF_OF_DELIVERY;
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfSender": {
                commitmentType = CommitmentType.PROOF_OF_SENDER;
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfApproval": {
                commitmentType = CommitmentType.PROOF_OF_APPROVAL;
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfCreation": {
                commitmentType = CommitmentType.PROOF_OF_CREATION;
            }
        }
        return commitmentType;
    }
}

