/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.TimeAttributeType;
import de.governikus.csl.validate.svp.TypedDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimedSigningTimeParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(ClaimedSigningTimeParser.class);

    public ClaimedSigningTimeParser(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("sigT".equals(parameterName) && parameterValue instanceof String) {
            TypedDate typedDate = new TypedDate();
            typedDate.setType(DateType.CLAIMED_SIGNING_TIME);
            String sigT = (String)parameterValue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssX");
            try {
                Date sigTDate = dateFormat.parse(sigT);
                typedDate.setDate(sigTDate);
                jadesSignature.setSigningTime(typedDate);
                this.addToSvp(jadesSignature, sigTDate);
            }
            catch (ParseException e) {
                jadesSignature.setParseError((ValidationResult)SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (String)"jades_header_info_signing_time_format"));
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private void addToSvp(JAdESSignature jadesSignature, Date sigTDate) {
        TimeAttributeType signingTime = new TimeAttributeType();
        signingTime.setSigned(Boolean.valueOf(true));
        signingTime.setTime(sigTDate);
        SignatureAttributesType signatureAttributes = jadesSignature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            jadesSignature.setSignatureAttributes(signatureAttributes);
        }
        List signatureAttributesList = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
        signatureAttributesList.add(this.svpFactory.createSignatureAttributesTypeSigningTime(signingTime));
    }
}

