/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateChainURLParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CertificateChainURLParser.class);
    private CertificateFactory certFac = CertificateFactory.getInstance("x509");

    public CertificateChainURLParser(ObjectFactory svpFactory) throws CertificateException {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object downloadUrl, JAdESSignature jadesSignature) {
        if ("x5u".equals(parameterName) && downloadUrl instanceof String) {
            byte[] downloadBytes = this.downloadCert((String)downloadUrl, parameterName);
            if (downloadBytes != null) {
                this.setCert(jadesSignature, downloadBytes);
            } else {
                logger.trace("Skip adding certificate(s) from URL '{}' to signature because an error during the download occured. [parameterName={}]", downloadUrl, (Object)parameterName);
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, downloadUrl, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    private byte[] downloadCert(String url, String parameterName) {
        try {
            URL downloadUrl = new URL(url);
            return IOUtils.toByteArray((URLConnection)downloadUrl.openConnection());
        }
        catch (Exception e) {
            logger.warn("Error while downloading certificate(s). [parameterName={}]", (Object)parameterName, (Object)e);
            return null;
        }
    }

    private void setCert(JAdESSignature jadesSignature, byte[] downloadBytes) {
        Collection<? extends Certificate> certChain = this.parseCertChain(downloadBytes);
        if (certChain.isEmpty()) {
            return;
        }
        boolean first = true;
        for (Certificate certificate : certChain) {
            if (!(certificate instanceof X509Certificate)) continue;
            if (first && jadesSignature.getSigningCertificate() == null) {
                jadesSignature.setSigningCertificate(new X509CertificateImpl((X509Certificate)certificate));
                first = false;
                continue;
            }
            HashSet<SignatureValidationDataAttachmentImpl> attachedCertificates = jadesSignature.getAttachedCertificates();
            if (attachedCertificates == null) {
                attachedCertificates = new HashSet<SignatureValidationDataAttachmentImpl>();
                jadesSignature.setAttachedCertificates(attachedCertificates);
            }
            attachedCertificates.add(new SignatureValidationDataAttachmentImpl((Object)((X509Certificate)certificate)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<? extends Certificate> parseCertChain(byte[] downloadBytes) {
        try (ByteArrayInputStream certBais = new ByteArrayInputStream(downloadBytes);){
            Collection<? extends Certificate> collection = this.certFac.generateCertificates(certBais);
            return collection;
        }
        catch (Exception e) {
            logger.trace("Downloaded bytes were not parsable as certificate chain.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

