/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.headerparams;

import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.SignedHeaderParameterParser;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateChainParser
extends SignedHeaderParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(CertificateChainParser.class);
    private final CertificateFactory certFac = CertificateFactory.getInstance("x509");

    public CertificateChainParser(ObjectFactory svpFactory) throws CertificateException {
        super(svpFactory);
    }

    @Override
    public void parseHeaderParameter(String parameterName, Object parameterValue, JAdESSignature jadesSignature) {
        if ("x5c".equals(parameterName)) {
            if (parameterValue instanceof List) {
                List<Object> signCertChain = JsonWebSignatureHelper.parseJsonAsObjectList(parameterValue);
                for (int i = 0; i < signCertChain.size(); ++i) {
                    byte[] certBytes;
                    X509Certificate cert;
                    Object signCertObj = signCertChain.get(i);
                    if (!(signCertObj instanceof String) || (cert = this.generateX509Certificate(certBytes = Base64.getDecoder().decode(((String)signCertObj).getBytes()))) == null) continue;
                    X509CertificateImpl certificateImpl = new X509CertificateImpl(cert);
                    if (i == 0) {
                        jadesSignature.setSigningCertificate(certificateImpl);
                        continue;
                    }
                    this.getAttachmentCertList(jadesSignature).add((SignatureValidationDataAttachment<X509Certificate>)new SignatureValidationDataAttachmentImpl((Object)certificateImpl));
                }
            }
        } else if (this.nextParser != null) {
            this.nextParser.parseHeaderParameter(parameterName, parameterValue, jadesSignature);
        } else {
            logger.trace("Header parameter of JAdESSignature not processable. [parameterName={}]", (Object)parameterName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate generateX509Certificate(byte[] encode) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(encode);){
            X509Certificate x509Certificate = (X509Certificate)this.certFac.generateCertificate(bais);
            return x509Certificate;
        }
        catch (Exception e) {
            logger.error("Cannot parse certificate in cert chain of x5c header parameter", (Throwable)e);
            return null;
        }
    }

    private Set<SignatureValidationDataAttachment<X509Certificate>> getAttachmentCertList(JAdESSignature jadesSignature) {
        HashSet attachedCertificates = jadesSignature.getAttachedCertificates();
        if (attachedCertificates == null) {
            attachedCertificates = new HashSet();
            jadesSignature.setAttachedCertificates(attachedCertificates);
        }
        return attachedCertificates;
    }
}

