/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.criteria;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.jades.JAdESCertificateReference;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.JAdESSignaturePolicyId;
import de.governikus.csl.jades.JAdESSignaturePolicyStore;
import de.governikus.csl.jades.json.EtsiUHeaderParams;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.DigestUtil;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.JAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESHeadersCheck
extends AbstractValidationCriterion<JAdESSignature, JAdESSignatureValidationResult, SignatureValidationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESHeadersCheck.class);
    private static final List<String> REFS_NAMES = java.util.Arrays.asList("xRefs", "axRefs", "rRefs", "arRefs");

    public void verify(JAdESSignature signature, JAdESSignatureValidationResult result, SignatureValidationContext context) {
        ValidationResult checkContentTypeHeaders = this.checkContentTypeHeaders(signature);
        ValidationResult checkSigningCertificateHeaders = this.checkSigningCertificateHeaders(signature);
        ValidationResult checkSha1CertificateThumbprintHeader = this.checkSha1CertificateThumbprintHeader(signature);
        ValidationResult checkClaimedSigningTimeHeaders = this.checkClaimedSigningTimeHeaders(signature);
        ValidationResult checkKeyIdHeaders = this.checkKeyIdHeaders(signature);
        ValidationResult checkCritHeader = this.checkCritHeader(signature);
        ValidationResult checkSigPIdHeader = this.checkSigPIdHeader(signature);
        ValidationResult checkRfsTstHeader = this.checkRfsTstHeader(signature);
        ValidationResult checkSigRTstHeader = this.checkSigRTstHeader(signature);
        CumulatedValidationResult checkCertificateThumbprintHeaders = this.checkCertificateThumbprintHeaders(signature);
        result.setJWSHeadersCheck(SVPFactory.create((de.governikus.csl.uom.validate.commons.ValidationResult)SignalAggregateUtil.aggregateCumulated((boolean)true, (ResultAggregator[])new ResultAggregator[]{SignalAggregateUtil.aggregate((de.governikus.csl.uom.validate.commons.ValidationResult[])new de.governikus.csl.uom.validate.commons.ValidationResult[]{checkContentTypeHeaders, checkSigningCertificateHeaders, checkSha1CertificateThumbprintHeader, checkClaimedSigningTimeHeaders, checkKeyIdHeaders, checkCritHeader, checkSigPIdHeader, checkRfsTstHeader, checkSigRTstHeader}), checkCertificateThumbprintHeaders})));
    }

    private ValidationResult checkContentTypeHeaders(JAdESSignature signature) {
        if (signature.getJwsContentTypeHeader() != null && signature.getJwsDetachedContentsHeader() != null) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_content_type");
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkKeyIdHeaders(JAdESSignature signature) {
        if (signature.getJwsProtectedHeaders().containsKey("kid")) {
            byte[] issuerSerial = DigestUtil.getIssuerSerialBytes((X509Certificate)signature.getSigningCertificate());
            if (issuerSerial == null) {
                issuerSerial = new byte[]{};
            }
            byte[] headerBytes = new byte[]{};
            String headerString = signature.getJwsProtectedHeaders().get("kid").toString();
            try {
                headerBytes = Base64.getUrlDecoder().decode(headerString);
            }
            catch (IllegalArgumentException e) {
                try {
                    headerBytes = Base64.getDecoder().decode(headerString);
                }
                catch (IllegalArgumentException b64normalDecodingEx) {
                    LOG.error("Failed to decode Key Id Header value using base64url decoding algorithm.", (Throwable)e);
                    LOG.error("Failed to decode Key Id Header value using standard base64 decoding algorithm.", (Throwable)b64normalDecodingEx);
                }
            }
            if (!Arrays.areEqual((byte[])issuerSerial, (byte[])headerBytes)) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_key_id");
            }
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkSha1CertificateThumbprintHeader(JAdESSignature signature) {
        if (signature.getJwsSha1ThumbprintHeader() == null) {
            return SVPFactory.createResultOk();
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_signing_certificate_thumbprint_sha_1");
    }

    private CumulatedValidationResult checkCertificateThumbprintHeaders(JAdESSignature signature) {
        List signCertRefs = signature.getSigningCertificateReferences();
        if (signCertRefs == null || signCertRefs.isEmpty()) {
            return SignalAggregateUtil.aggregate(Collections.singletonList(SVPFactory.createResultOk()));
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        for (CertificateReference certRef : signCertRefs) {
            if (!(certRef instanceof JAdESCertificateReference)) continue;
            JAdESCertificateReference jadesCertRef = (JAdESCertificateReference)certRef;
            DigestAlgorithm digestAlgorithm = jadesCertRef.getDigestAlgorithm();
            if (digestAlgorithm == null) {
                String unknownAlgoName = jadesCertRef.getUnknownAlgoName();
                if (unknownAlgoName == null || unknownAlgoName.isEmpty()) {
                    unknownAlgoName = "unknown";
                }
                results.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"jades_header_info_unknown_algo", (Object[])new Object[]{unknownAlgoName})));
                continue;
            }
            String headerParamSource = jadesCertRef.getHeaderParamSource();
            if ("SHA-256".equals(digestAlgorithm.getJCAName()) && "x5t#o".equals(headerParamSource)) {
                results.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_cert_digest_forbidden_algo"));
                continue;
            }
            boolean hashesMatch = certRef.isReferenced((Certificate)signingCertificate);
            if (hashesMatch) {
                results.add(SVPFactory.createResultOk());
                continue;
            }
            results.add(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"jades_header_info_cert_digest_wrong", (Object[])new Object[]{headerParamSource})));
        }
        return SignalAggregateUtil.aggregate(results);
    }

    private ValidationResult checkSigningCertificateHeaders(JAdESSignature signature) {
        if (signature.getJwsProtectedHeaders().containsKey("x5t#S256") || signature.getJwsProtectedHeaders().containsKey("x5c") || signature.getJwsProtectedHeaders().containsKey("sigX5ts") || signature.getJwsProtectedHeaders().containsKey("x5t#o")) {
            return SVPFactory.createResultOk();
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_signing_certificate");
    }

    private ValidationResult checkCritHeader(JAdESSignature signature) {
        if (!this.areAllCriticalHeadersKnown(signature)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_crit_header_unknown");
        }
        if (!this.isCritHeaderValueSubsetOfProtectedHeaders(signature)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_crit_header");
        }
        if (!this.areAllCriticalHeadersDeclaredCorrectly(signature)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_crit_header");
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkClaimedSigningTimeHeaders(JAdESSignature signature) {
        if (signature.getJwsSigningTimeHeader() == null) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_signing_time_missing");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssX");
        try {
            dateFormat.parse(signature.getJwsSigningTimeHeader());
        }
        catch (ParseException e) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_signing_time_format");
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkSigPIdHeader(JAdESSignature signature) {
        JAdESSignaturePolicyId signaturePolicyId = signature.getSignaturePolicyId();
        if (signaturePolicyId == null) {
            return SVPFactory.createResultOk();
        }
        String jwsAlgo = signaturePolicyId.getSignaturePolicyDigestAlgorithm();
        byte[] digVal = signaturePolicyId.getSignaturePolicyDigestValue();
        if (jwsAlgo == null || digVal == null) {
            return SVPFactory.createResultOk();
        }
        JAdESSignaturePolicyStore signaturePolicyStore = signature.getSignaturePolicyStore();
        if (signaturePolicyStore == null) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_sigpid_policy_store_missing");
        }
        byte[] policy = signaturePolicyStore.getSignaturePolicyBytes();
        if (policy == null) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"jades_header_info_sigpid_policy_store_empty");
        }
        String algorithm = JsonWebSignatureHelper.mapJWSAlgoToJCA(jwsAlgo);
        if (algorithm == null) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"jades_header_info_unknown_algo", (Object[])new Object[]{jwsAlgo}));
        }
        if (!this.doHashesMatch(digVal, algorithm, policy)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (String)"jades_header_info_sigpid_hash_mismatch");
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkRfsTstHeader(JAdESSignature signature) {
        return this.checkRefsPresence(signature, "rfsTst");
    }

    private ValidationResult checkSigRTstHeader(JAdESSignature signature) {
        return this.checkRefsPresence(signature, "sigRTst");
    }

    private ValidationResult checkRefsPresence(JAdESSignature signature, String headerName) {
        EtsiUHeaderParams etsiUHeaderParams = signature.getEtsiUHeaderParams();
        if (etsiUHeaderParams == null || etsiUHeaderParams.isEmpty()) {
            return SVPFactory.createResultOk();
        }
        if (etsiUHeaderParams.contains(headerName) && etsiUHeaderParams.containsNot(REFS_NAMES)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"jades_header_info_reftst_content_missing", (Object[])new Object[]{headerName}));
        }
        return SVPFactory.createResultOk();
    }

    private boolean doHashesMatch(byte[] compareTo, String hashAlgo, byte[] toBeHashed) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgo);
            return MessageDigest.isEqual(compareTo, md.digest(toBeHashed));
        }
        catch (Exception e) {
            LOG.error("Cannot compare hashes", (Throwable)e);
            return false;
        }
    }

    private boolean areAllCriticalHeadersKnown(JAdESSignature signature) {
        List<String> critHeader = signature.getJwsCritHeader();
        if (critHeader == null) {
            return true;
        }
        for (String c : critHeader) {
            if (JsonWebSignatureHelper.isCrit(c)) continue;
            return false;
        }
        return true;
    }

    private boolean areAllCriticalHeadersDeclaredCorrectly(JAdESSignature signature) {
        List<String> critHeader = signature.getJwsCritHeader();
        Set<String> headers = signature.getJwsProtectedHeaders().keySet();
        for (String header : headers) {
            if (!JsonWebSignatureHelper.isCrit(header) || critHeader != null && critHeader.contains(header)) continue;
            return false;
        }
        return true;
    }

    private boolean isCritHeaderValueSubsetOfProtectedHeaders(JAdESSignature signature) {
        List<String> critHeader = signature.getJwsCritHeader();
        Set<String> headers = signature.getJwsProtectedHeaders().keySet();
        return critHeader == null || headers.containsAll(critHeader);
    }
}

