/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.jades.JAdESSignaturePolicyId;
import de.governikus.csl.jades.JAdESSignaturePolicyStore;
import de.governikus.csl.jades.json.EtsiUHeaderParams;
import de.governikus.csl.jades.util.TimestampValidationData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JAdESSignature
extends AdESSignature {
    private Map<String, Object> jwsProtectedHeaders;
    private Map<String, Object> jwsUnprotectedHeaders;
    private byte[] jwsPayload;
    private EtsiUHeaderParams etsiUHeaderParams;
    private List<TimestampValidationData> timestampValidationDataList = new ArrayList<TimestampValidationData>();
    private JAdESSignaturePolicyStore signaturePolicyStore;
    private JAdESSignaturePolicyId signaturePolicyId;
    private byte[] messageDigestValue;

    public EtsiUHeaderParams getEtsiUHeaderParams() {
        return this.etsiUHeaderParams;
    }

    public void setEtsiUHeaderParams(EtsiUHeaderParams etsiUHeaderParams) {
        this.etsiUHeaderParams = etsiUHeaderParams;
    }

    public List<TimestampValidationData> getTimestampValidationDataList() {
        return this.timestampValidationDataList;
    }

    public JAdESSignaturePolicyStore getSignaturePolicyStore() {
        return this.signaturePolicyStore;
    }

    public void setSignaturePolicyStore(JAdESSignaturePolicyStore signaturePolicyStore) {
        this.signaturePolicyStore = signaturePolicyStore;
    }

    public JAdESSignaturePolicyId getSignaturePolicyId() {
        return this.signaturePolicyId;
    }

    public void setSignaturePolicyId(JAdESSignaturePolicyId signaturePolicyId) {
        this.signaturePolicyId = signaturePolicyId;
    }

    public byte[] getMessageDigestValue() {
        return this.messageDigestValue;
    }

    public void setMessageDigestValue(byte[] messageDigestValue) {
        this.messageDigestValue = messageDigestValue;
    }

    public String getJwsSignatureAlgorithmHeader() {
        return this.getHeaderStringValue("alg");
    }

    public String getJwsContentTypeHeader() {
        return this.getHeaderStringValue("cty");
    }

    public String getJwsSigningTimeHeader() {
        return this.getHeaderStringValue("sigT");
    }

    public List<String> getJwsCertificateChainHeader() {
        return this.getHeader("x5c", new TypeReference<List<String>>(){});
    }

    public Map<String, Object> getJwsDetachedContentsHeader() {
        return this.getHeader("sigD", new TypeReference<Map<String, Object>>(){});
    }

    public String getJwsSha1ThumbprintHeader() {
        return this.getHeaderStringValue("x5t");
    }

    public List<String> getJwsCritHeader() {
        return this.getHeader("crit", new TypeReference<List<String>>(){});
    }

    public Map<String, Object> getJwsX509DigestHeader() {
        return this.getHeader("x5t#o", new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getJwsSigPIdHeader() {
        return this.getHeader("sigPId", new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getJwsProtectedHeaders() {
        return this.jwsProtectedHeaders;
    }

    public void setJwsProtectedHeaders(Map<String, Object> jwsProtectedHeaders) {
        this.jwsProtectedHeaders = jwsProtectedHeaders;
    }

    public Map<String, Object> getJwsUnprotectedHeaders() {
        return this.jwsUnprotectedHeaders;
    }

    public void setJwsUnprotectedHeaders(Map<String, Object> jwsUnprotectedHeaders) {
        this.jwsUnprotectedHeaders = jwsUnprotectedHeaders;
    }

    public byte[] getJwsPayload() {
        return this.jwsPayload;
    }

    public void setJwsPayload(byte[] jwsPayload) {
        this.jwsPayload = jwsPayload;
    }

    private String getHeaderStringValue(String key) {
        Object o = this.jwsProtectedHeaders.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private <T> T getHeader(String key, TypeReference<T> type) {
        Object o = this.jwsProtectedHeaders.get(key);
        if (o == null) {
            return null;
        }
        return (T)new ObjectMapper().convertValue(o, type);
    }
}

