/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades;

import de.governikus.csl.jades.JAdESDataExtractor;
import de.governikus.csl.jades.JAdESDocument;
import de.governikus.csl.jades.JAdESParser;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.criteria.JAdESHeadersCheck;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.validate.svp.JAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckCounterSignatures;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PluginType(id=Plugin.PluginID.VALIDATE_JADES, type=ValidatePlugin.class)
public class JAdESPlugin
extends AbstractDocumentPlugin<JAdESDocument, JAdESSignature, ObjectValidationResult, JAdESSignatureValidationResult, SignatureValidationContext> {
    private final JAdESParser parser = new JAdESParser();

    public JAdESPlugin() {
        super(JAdESSignature.class, SignatureValidationContext.class);
        this.supportedMimeTypes.add("application/json");
    }

    public JAdESDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            return this.parser.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", (Throwable)e);
        }
    }

    public ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        ObjectValidationResult objectValidationResult = new ObjectValidationResult();
        objectValidationResult.setObjectTypeID(Plugin.PluginID.VALIDATE_JADES.getID());
        return objectValidationResult;
    }

    public JAdESSignatureValidationResult createSignatureValidationResultStructure() {
        return new JAdESSignatureValidationResult();
    }

    public SignatureValidationContext createContext(JAdESSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public static List<ValidationCriterion<? super JAdESSignature, ? super JAdESSignatureValidationResult, ? super SignatureValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<JAdESHeadersCheck> additionalValidationCriteria = new ArrayList<JAdESHeadersCheck>();
        additionalValidationCriteria.add(new JAdESHeadersCheck());
        additionalValidationCriteria.add((JAdESHeadersCheck)new CheckCounterSignatures());
        return Collections.unmodifiableList(additionalValidationCriteria);
    }

    public DataExtractor<? super JAdESSignature, ? super JAdESSignatureValidationResult> getSignatureDataExtractor() {
        return new JAdESDataExtractor();
    }
}

