/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.ArchiveTimestamp;
import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.jades.ArchiveTimestampMessageImprintHelper;
import de.governikus.csl.jades.JAdESArchiveTimestamp;
import de.governikus.csl.jades.JAdESDocument;
import de.governikus.csl.jades.JAdESSignature;
import de.governikus.csl.jades.headerparams.CertificateChainParser;
import de.governikus.csl.jades.headerparams.CertificateChainURLParser;
import de.governikus.csl.jades.headerparams.ClaimedSigningTimeParser;
import de.governikus.csl.jades.headerparams.CommitmentTypeIndicationParser;
import de.governikus.csl.jades.headerparams.ContentTimestampParser;
import de.governikus.csl.jades.headerparams.CounterSignatureParser;
import de.governikus.csl.jades.headerparams.RefsTimestampParser;
import de.governikus.csl.jades.headerparams.SigValSigTstAndRefsTimestampParser;
import de.governikus.csl.jades.headerparams.SignaturePolicyIdParser;
import de.governikus.csl.jades.headerparams.SignaturePolicyStoreParser;
import de.governikus.csl.jades.headerparams.SignatureProductionPlaceParser;
import de.governikus.csl.jades.headerparams.SignatureTimestampParser;
import de.governikus.csl.jades.headerparams.SignerAttributesParser;
import de.governikus.csl.jades.headerparams.TimestampValidationDataParser;
import de.governikus.csl.jades.headerparams.X509CertificateAnyDigestListParser;
import de.governikus.csl.jades.headerparams.X509CertificateNonSHA256DigestParser;
import de.governikus.csl.jades.headerparams.X509CertificateSHA256DigestParser;
import de.governikus.csl.jades.headerparams.lta.CertificateRefsParser;
import de.governikus.csl.jades.headerparams.lta.CertificatesParser;
import de.governikus.csl.jades.headerparams.lta.RevocationRefsParser;
import de.governikus.csl.jades.headerparams.lta.RevocationValuesParser;
import de.governikus.csl.jades.json.EtsiUConformityException;
import de.governikus.csl.jades.json.EtsiUHeaderParamElement;
import de.governikus.csl.jades.json.EtsiUHeaderParams;
import de.governikus.csl.jades.json.JsonWebSignature;
import de.governikus.csl.jades.json.JsonWebSignatureHelper;
import de.governikus.csl.jades.util.Base64Util;
import de.governikus.csl.jades.util.JAdESLongTermValidationDataUtil;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validation.tsp.TSPParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESParser
extends AbstractDocumentParser<JAdESDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESParser.class);
    private static final String MESSAGE_DIGEST_ALGO_NAME = "SHA3-512";

    public JAdESDocument loadDocument(SignedData sda) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        String json = this.parseSignedData(sda);
        return this.parseJAdESSignature(sda.getSignature().getName(), json);
    }

    private JAdESDocument parseJAdESSignature(String name, String json) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        ArrayList<JAdESSignature> signatures = new ArrayList<JAdESSignature>();
        this.parseCompactSerialization(signatures, json);
        if (signatures.isEmpty()) {
            this.parseJSONFlattenSerialization(signatures, json);
        }
        if (signatures.isEmpty()) {
            this.parseJSONSerialization(signatures, json);
        }
        if (signatures.isEmpty()) {
            return null;
        }
        JAdESDocument jAdESDocument = new JAdESDocument();
        jAdESDocument.setName(name);
        jAdESDocument.setSignatures(signatures);
        return jAdESDocument;
    }

    private void parseJSONFlattenSerialization(List<JAdESSignature> signatures, String jws) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        JsonWebSignature signature = JsonWebSignatureHelper.fromJSON(jws, JsonWebSignature.class);
        if (signature.getPayload() != null && signature.getSignature() != null) {
            byte[] jwsSignedContent = JsonWebSignature.getSignatureInput(signature.getProtectedHeaders(), signature.getPayload());
            JAdESSignature jAdESSignature = this.createJAdESSignature(signature, signature.getSignature(), signature.getDecodedProtectedHeader(), signature.getDecodedSignatureValue(), jwsSignedContent, signature.getHeader());
            signatures.add(jAdESSignature);
        }
    }

    private void parseJSONSerialization(List<JAdESSignature> signatures, String jws) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        JsonWebSignature signature = JsonWebSignatureHelper.fromJSON(jws, JsonWebSignature.class);
        if (signature.getPayload() != null && signature.getSignatures() != null) {
            for (JsonWebSignature s : signature.getSignatures()) {
                byte[] jwsSignedContent = JsonWebSignature.getSignatureInput(s.getProtectedHeaders(), signature.getPayload());
                s.setPayload(signature.getPayload());
                signatures.add(this.createJAdESSignature(s, s.getSignature(), s.getDecodedProtectedHeader(), s.getDecodedSignatureValue(), jwsSignedContent, s.getHeader()));
            }
        }
    }

    private void parseCompactSerialization(List<JAdESSignature> signatures, String jws) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        String[] parts = this.getTokenParts(jws);
        if (parts == null) {
            return;
        }
        JsonWebSignature signature = new JsonWebSignature();
        signature.setProtectedHeaders(parts[0].trim());
        signature.setPayload(parts[1].trim());
        signature.setSignature(parts[2].trim());
        byte[] jwsSignedContent = JsonWebSignature.getSignatureInput(signature.getProtectedHeaders(), signature.getPayload());
        JAdESSignature jAdESSignature = this.createJAdESSignature(signature, signature.getSignature(), signature.getDecodedProtectedHeader(), signature.getDecodedSignatureValue(), jwsSignedContent, null);
        signatures.add(jAdESSignature);
    }

    private JAdESSignature createJAdESSignature(JsonWebSignature s, String signatureValue, Map<String, Object> jwsProtectedHeaders, byte[] jwsSignatureValue, byte[] jwsSignedContent, Map<String, Object> jwsUnprotectedHeaders) throws IOException, GeneralSecurityException, CoreException, EtsiUConformityException {
        JAdESSignature signature = new JAdESSignature();
        signature.setJwsProtectedHeaders(jwsProtectedHeaders);
        signature.setJwsUnprotectedHeaders(jwsUnprotectedHeaders);
        signature.setJwsPayload(s.getPayload().getBytes(StandardCharsets.UTF_8));
        signature.setSignatureValue(jwsSignatureValue);
        signature.setSignedContent((Document)new ByteArrayDocument(jwsSignedContent));
        signature.setEtsiUHeaderParams(JsonWebSignatureHelper.parseEtsiUHeader(signature));
        this.setMessageDigest(signature, jwsSignedContent);
        this.processSignatureAlgorithm(signature);
        this.processUnsignedHeader(signature, s);
        this.processProtectedHeader(signature);
        if (LOG.isDebugEnabled()) {
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, Object> jws = new HashMap<String, Object>();
            jws.put("protected", signature.getJwsProtectedHeaders());
            jws.put("signature", signatureValue);
            jws.put("payload", signature.getJwsPayload());
            if (signature.getJwsUnprotectedHeaders() != null) {
                jws.put("header", JsonWebSignatureHelper.parseEtsiUHeader(signature));
            }
            LOG.debug("{}{}", (Object)System.lineSeparator(), (Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jws));
        }
        return signature;
    }

    private void setMessageDigest(JAdESSignature signature, byte[] jwsSignedContent) {
        try {
            signature.setMessageDigestValue(MessageDigest.getInstance(MESSAGE_DIGEST_ALGO_NAME).digest(jwsSignedContent));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot create JAdES message digest using {}", (Object)MESSAGE_DIGEST_ALGO_NAME);
        }
    }

    private void processProtectedHeader(JAdESSignature signature) throws CertificateException, CoreException {
        ObjectFactory svpFactory = new ObjectFactory();
        SignatureProductionPlaceParser protectedHeaderParameterParser = new SignatureProductionPlaceParser(svpFactory);
        protectedHeaderParameterParser.append(new CommitmentTypeIndicationParser(svpFactory)).append(new SignerAttributesParser(svpFactory)).append(new ContentTimestampParser(svpFactory)).append(new CertificateChainURLParser(svpFactory)).append(new SignaturePolicyIdParser(svpFactory)).append(new CertificateChainParser(svpFactory)).append(new X509CertificateAnyDigestListParser(svpFactory)).append(new X509CertificateNonSHA256DigestParser(svpFactory)).append(new X509CertificateSHA256DigestParser(svpFactory)).append(new ClaimedSigningTimeParser(svpFactory));
        Map<String, Object> jwsProtectedHeaders = signature.getJwsProtectedHeaders();
        if (jwsProtectedHeaders != null) {
            for (Map.Entry<String, Object> headerParameter : jwsProtectedHeaders.entrySet()) {
                protectedHeaderParameterParser.parseHeaderParameter(headerParameter.getKey(), headerParameter.getValue(), signature);
            }
        }
    }

    private void processUnsignedHeader(JAdESSignature signature, JsonWebSignature jws) throws CoreException, EtsiUConformityException {
        Map<String, Object> parameterMap;
        ObjectFactory svpFactory = new ObjectFactory();
        this.processArchiveTimestamps(signature, jws);
        Base64Util base64Util = new Base64Util();
        CounterSignatureParser unsignedHeaderParameterParser = new CounterSignatureParser(svpFactory, this, base64Util);
        unsignedHeaderParameterParser.append(new CertificatesParser(svpFactory)).append(new RevocationValuesParser(svpFactory)).append(new CertificateRefsParser(svpFactory)).append(new RevocationRefsParser(svpFactory)).append(new RefsTimestampParser(svpFactory)).append(new SigValSigTstAndRefsTimestampParser(svpFactory)).append(new SignatureTimestampParser(svpFactory)).append(new SignaturePolicyStoreParser(svpFactory));
        EtsiUHeaderParams etsiUHeaders = signature.getEtsiUHeaderParams();
        if (etsiUHeaders == null || etsiUHeaders.isEmpty()) {
            return;
        }
        TimestampValidationDataParser timestampValidationDataParser = new TimestampValidationDataParser(svpFactory);
        for (EtsiUHeaderParamElement etsiUHeader : etsiUHeaders) {
            parameterMap = etsiUHeader.getParameterMap();
            if (parameterMap == null || !parameterMap.containsKey("tstVD")) continue;
            timestampValidationDataParser.parseHeaderParameter(etsiUHeader, signature);
        }
        for (EtsiUHeaderParamElement etsiUHeader : etsiUHeaders) {
            parameterMap = etsiUHeader.getParameterMap();
            if (parameterMap == null || parameterMap.containsKey("tstVD")) continue;
            unsignedHeaderParameterParser.parseHeaderParameter(etsiUHeader, signature);
        }
    }

    private void processArchiveTimestamps(JAdESSignature signature, JsonWebSignature jws) throws CoreException, EtsiUConformityException {
        ArrayList<JAdESArchiveTimestamp> timestamps = new ArrayList<JAdESArchiveTimestamp>();
        EtsiUHeaderParams etsiUHeaders = JsonWebSignatureHelper.parseEtsiUHeader(signature);
        if (etsiUHeaders == null || etsiUHeaders.isEmpty()) {
            return;
        }
        for (EtsiUHeaderParamElement etsiUHeader : etsiUHeaders) {
            Map<String, Object> arcTst;
            Map<String, Object> parameterMap = etsiUHeader.getParameterMap();
            if (!parameterMap.containsKey("arcTst") || !(arcTst = JsonWebSignatureHelper.parseJsonAsMap(parameterMap.get("arcTst"))).containsKey("tstTokens")) continue;
            List<Object> tstTokens = JsonWebSignatureHelper.parseJsonAsObjectList(arcTst.get("tstTokens"));
            for (Object tstTokenObject : tstTokens) {
                Map<String, Object> tstToken = JsonWebSignatureHelper.parseJsonAsMap(tstTokenObject);
                List<JAdESArchiveTimestamp> timestampToken = this.parseArchiveTimestampToken(signature.getJwsProtectedHeaders(), tstToken.get("val"), jws, JsonWebSignatureHelper.parseJsonAsMap(etsiUHeaders.getFirstParamMapByName("tstVD")));
                timestamps.addAll(timestampToken);
            }
            signature.setArchiveTimestamps(timestamps);
        }
    }

    private List<JAdESArchiveTimestamp> parseArchiveTimestampToken(Map<String, Object> jwsProtectedHeaders, Object token, JsonWebSignature jws, Map<String, Object> tstVD) throws CoreException {
        byte[] decodedToken = Base64.getDecoder().decode(token.toString());
        try {
            ArchiveTimestamp ts = new ArchiveTimestamp(Run.create((Source)new BSource(decodedToken)), 1);
            TSPParser tspParser = new TSPParser((AlgorithmManager)new AlgorithmServiceFacade());
            List archiveTimestamps = tspParser.parse((de.bos_bremen.ci.asn1.cms.SignedData)ts.getContent(), null, JAdESArchiveTimestamp::new);
            byte[] timestampedContent = ArchiveTimestampMessageImprintHelper.getTimestampedContent(jwsProtectedHeaders, jws);
            for (JAdESArchiveTimestamp archiveTimestamp : archiveTimestamps) {
                archiveTimestamp.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(timestampedContent));
                JAdESLongTermValidationDataUtil.addAttachmentsFromTstVDContainer((BaseSignature)archiveTimestamp, tstVD);
            }
            return archiveTimestamps;
        }
        catch (ParseException | IOException e) {
            return Collections.emptyList();
        }
    }

    private void processSignatureAlgorithm(JAdESSignature signature) {
        String alg = signature.getJwsSignatureAlgorithmHeader();
        String algorithm = JsonWebSignatureHelper.mapJWSAlgoToJCA(alg);
        signature.setSignatureAlgorithm(AlgorithmService.getSignatureForName((String)algorithm));
    }

    private String[] getTokenParts(String jws) {
        String[] parts = jws.split("\\.");
        if (parts == null || parts.length != 3) {
            return null;
        }
        return parts;
    }

    private String parseSignedData(SignedData sda) throws IOException {
        try (InputStream signatureData = sda.getSignature().getInputStream();){
            String string = IOUtils.toString((InputStream)signatureData, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

