/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csl.jades.json.JsonCanonicalizerUtil;
import de.governikus.csl.jades.json.JsonWebSignature;
import de.governikus.csl.uom.CoreException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTimestampMessageImprintHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveTimestampMessageImprintHelper.class);
    static final String SIGD_ERR_MSG = "Validation of detached content not implemented yet";

    private ArchiveTimestampMessageImprintHelper() {
    }

    public static byte[] getTimestampedContent(Map<String, Object> jwsProtectedHeaders, JsonWebSignature jwSig) throws IOException, CoreException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object sigD = jwsProtectedHeaders.get("sigD");
            ArchiveTimestampMessageImprintHelper.addPayload(sigD, baos, jwSig);
            baos.write(".".getBytes());
            baos.write(jwSig.getProtectedHeaders().getBytes());
            baos.write(".".getBytes());
            baos.write(jwSig.getSignature().getBytes());
            baos.write(".".getBytes());
            ArchiveTimestampMessageImprintHelper.addUnsignedHeaderParams(baos, jwSig);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    static void addPayload(Object sigD, OutputStream baos, JsonWebSignature jwSig) throws IOException, CoreException {
        boolean contentWritten = false;
        try {
            if (sigD == null) {
                baos.write(jwSig.getPayload().getBytes(StandardCharsets.UTF_8));
                contentWritten = true;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot write payload to tst imprint bytes", (Throwable)e);
        }
        if (!contentWritten) {
            LOG.error(SIGD_ERR_MSG);
            throw new CoreException(SIGD_ERR_MSG);
        }
    }

    static void addUnsignedHeaderParams(OutputStream baos, JsonWebSignature jwSig) throws IOException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> jwsUnprotectedHeaders = jwSig.getHeader();
            if (jwsUnprotectedHeaders != null && jwsUnprotectedHeaders.containsKey("etsiU")) {
                List headerValueList = (List)mapper.convertValue(jwsUnprotectedHeaders.get("etsiU"), (TypeReference)new TypeReference<List<Object>>(){});
                if (headerValueList.isEmpty()) {
                    return;
                }
                for (Object headerValue : headerValueList) {
                    if (!(headerValue instanceof String)) continue;
                    ArchiveTimestampMessageImprintHelper.writeB64UrlEncHeader((String)headerValue, mapper, baos);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cannot add unsiged header(s) to imprint bytes", (Throwable)e);
        }
    }

    private static void writeB64UrlEncHeader(String headerValue, ObjectMapper mapper, OutputStream baos) throws IOException {
        byte[] decoded = Base64.getUrlDecoder().decode(headerValue.getBytes());
        String decString = new String(decoded, StandardCharsets.UTF_8);
        Map headerKeyValueMap = (Map)mapper.readValue(decString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (!headerKeyValueMap.containsKey("arcTst") && !headerKeyValueMap.containsKey("tstVD")) {
            baos.write(headerValue.getBytes());
        }
    }

    private static void writeCanonicalizedValue(Object object, String canonAlgo, OutputStream baos) throws IOException {
        byte[] bytesToWrite = ArchiveTimestampMessageImprintHelper.getCanonicalizedValue(object, canonAlgo);
        baos.write(bytesToWrite);
    }

    private static byte[] getCanonicalizedValue(Object object, String canonAlgo) throws IOException {
        if (canonAlgo != null) {
            LOG.warn("Canonicalization with an explicit algorithm is not yet supported.");
        }
        if (object instanceof Map) {
            return new JsonCanonicalizerUtil().canonicalizeJsonMapAsString((Map)object).getBytes();
        }
        if (object instanceof String) {
            return new JsonCanonicalizerUtil().canonicalizeJsonStringAsString((String)object).getBytes();
        }
        LOG.debug("Can not canonicalize value. Must be a Map or String");
        throw new IOException("Can not canonicalize value");
    }
}

