/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.AlgorithmValidityResult;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.DigestAlgorithmValidityInformation;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.ServiceInfo;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import java.util.Collection;
import java.util.List;

public class ValidationResultPrinter {
    public static String printSignature(SignatureValidationResult svr) {
        List<AttributeCertificateValidationResult> list;
        List<TimestampValidationResult> signedDataTimestampResults;
        List<TimestampValidationResult> signatureTimestampResults;
        if (svr == null) {
            return "SignatureValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        ValidationResultPrinter.appendValidationResult(sb, svr.getSignatureMathCheck(), "signatureMathCheck");
        ValidationResultPrinter.appendValidationResult(sb, svr.getTimestampDelayCheck(), "timestampDelayCheck");
        ValidationResultPrinter.appendValidationResult(sb, svr.getTimestampOrderingCheck(), "timestampOrderingCheck");
        ValidationResultPrinter.appendValidationResult(sb, svr.getSigningCertificateUsageCheck(), "signingCertificateUsageCheck");
        ValidationResultPrinter.appendValidationResult(sb, svr.getClaimedSigningTimeCheck(), "claimedSigningTimeCheck");
        ValidationResultPrinter.appendAlgorithmValidityAtX(sb, svr.getSignatureAlgorithmValidityAtBestPOE(), "signatureAlgorithmValidityAtBestPOE");
        ValidationResultPrinter.appendAlgorithmValidityAtX(sb, svr.getSignatureAlgorithmValidityAtValidationDate(), "signatureAlgorithmValidityAtValidationDate");
        ValidationResultPrinter.appendAlgorithmValidityAtX(sb, svr.getSignatureAlgorithmValidityAtClaimedSigningTime(), "signatureAlgorithmValidityAtClaimedSigningTime");
        PublicKeyCertificateValidationResult signingCertificateValidationResult = svr.getSigningCertificateValidationResult();
        if (signingCertificateValidationResult != null) {
            sb.append("Signing certificate ");
            X509CertificateImpl cert = signingCertificateValidationResult.getCert();
            if (cert != null) {
                String string = cert.getSubjectX500Principal().toString();
                ValidationResultPrinter.appendText(sb, "(", string, ")");
            }
            Object signingCertificateResultAsString = ValidationResultPrinter.printPublicKeyCertificate(signingCertificateValidationResult);
            signingCertificateResultAsString = ValidationResultPrinter.indentLines((String)signingCertificateResultAsString);
            ValidationResultPrinter.appendText(sb, ":\n", (String)signingCertificateResultAsString, "\n");
        }
        if ((signatureTimestampResults = svr.getSignatureTimestampResults()) != null && !signatureTimestampResults.isEmpty()) {
            sb.append("signature timestamps: \n");
            for (TimestampValidationResult timestampValidationResult : signatureTimestampResults) {
                if (timestampValidationResult == null) continue;
                String string = ValidationResultPrinter.printTimestamp(timestampValidationResult);
                string = ValidationResultPrinter.indentLines(string);
                ValidationResultPrinter.appendLine(sb, string);
            }
        }
        if ((signedDataTimestampResults = svr.getSignedDataTimestampResults()) != null && !signedDataTimestampResults.isEmpty()) {
            sb.append("signed data timestamps: \n");
            for (TimestampValidationResult ts : signedDataTimestampResults) {
                if (ts == null) continue;
                String string = ValidationResultPrinter.printTimestamp(ts);
                string = ValidationResultPrinter.indentLines(string);
                ValidationResultPrinter.appendLine(sb, string);
            }
        }
        if ((list = svr.getAttributeCertificateValidationResults()) != null && !list.isEmpty()) {
            sb.append("attribute certificates: \n");
            for (AttributeCertificateValidationResult acvr : list) {
                if (acvr == null) continue;
                String string = ValidationResultPrinter.printAttributeCertificate(acvr);
                string = ValidationResultPrinter.indentLines(string);
                ValidationResultPrinter.appendLine(sb, string);
            }
        }
        return sb.toString();
    }

    public static void appendAlgorithmValidityAtX(StringBuilder sb, AlgorithmValidityResult signatureAlgorithmValidityAtX, String title) {
        if (signatureAlgorithmValidityAtX != null) {
            ValidationResultPrinter.appendValidationResult(sb, signatureAlgorithmValidityAtX.getSignatureAlgorithmValidationResult(), title);
            Collection digestAlgorithmValidationResults = signatureAlgorithmValidityAtX.getDigestAlgorithmValidationResults();
            if (digestAlgorithmValidationResults != null) {
                for (DigestAlgorithmValidityInformation davi : digestAlgorithmValidationResults) {
                    ValidationResultPrinter.appendValidationResult(sb, davi.getValidationResult(), "digestAlgorithmValidity", "\t");
                }
            }
        }
    }

    public static void appendValidationResult(StringBuilder sb, ValidationResult vr, String title) {
        if (vr != null) {
            ValidationResultPrinter.appendValidationResult(sb, vr, title, null);
        }
    }

    public static void appendValidationResult(StringBuilder sb, ValidationResult vr, String title, String indent) {
        if (vr != null) {
            if (indent != null) {
                sb.append(indent);
            }
            sb.append(title);
            sb.append(" : ");
            ValidationResultPrinter.appendValidationResult(sb, vr);
            sb.append("\n");
        }
    }

    public static void appendValidationResult(StringBuilder sb, ValidationResult vr) {
        List<ValidationMessageCode> messages;
        sb.append(vr.getMajor());
        MinorResult minor = vr.getMinor();
        if (minor != null) {
            sb.append("/");
            sb.append(minor);
        }
        if ((messages = vr.getMessages()) != null && !messages.isEmpty()) {
            sb.append("[");
            ValidationResultPrinter.appendMessages(sb, messages);
            sb.append("]");
        }
    }

    public static void appendMessages(StringBuilder sb, List<ValidationMessageCode> messages) {
        boolean first = true;
        for (ValidationMessageCode vmc : messages) {
            first = ValidationResultPrinter.appendListItem(sb, first, vmc.getMessageCode());
        }
    }

    public static boolean appendListItem(StringBuilder sb, boolean first, Object listItem) {
        if (first) {
            first = false;
        } else {
            sb.append(",");
        }
        sb.append(listItem);
        return first;
    }

    public static String printAttributeCertificate(AttributeCertificateValidationResult acvr) {
        if (acvr == null) {
            return "AttributeCertificateValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        ValidationResultPrinter.appendValidationResult(sb, acvr.getBaseCertificateCheck(), "baseCertificateCheck");
        String s = ValidationResultPrinter.printCertificate(acvr);
        sb.append(s);
        return sb.toString();
    }

    public static String printTimestamp(TimestampValidationResult tsvr) {
        if (tsvr == null) {
            return "TimestampValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        ValidationResultPrinter.appendValidationResult(sb, tsvr.getImprintCheck(), "imprintCheck");
        ValidationResultPrinter.appendValidationResult(sb, tsvr.getMessageImprintAlgorithmCheck(), "messageImprintAlgorithmCheck");
        ValidationResultPrinter.appendValidationResult(sb, tsvr.getExtendedKeyUsageCheck(), "extendedKeyUsageCheck");
        String s = ValidationResultPrinter.printSignature(tsvr);
        sb.append(s);
        return sb.toString();
    }

    public static String printCertificate(CertificateValidationResult cvr) {
        if (cvr == null) {
            return "CertificateValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        ValidationResultPrinter.appendLine(sb, "informationSource : " + cvr.getInformationSource());
        ValidationResultPrinter.appendValidationResult(sb, cvr.getCertChainCheck(), "certChainCheck");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getValidityCheck(), "validityCheck");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getCvsResponseSignatureValidationResult(), "cvsResponseSignatureValidationResult");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getCvsForwardedResponseSignatureValidationResult(), "cvsForwardedResponseSignatureValidationResult");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getRevocationStatusCheck(), "revocationStatusCheck");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getRevocationTrustCheckResult(), "revocationTrustCheck");
        ValidationResultPrinter.appendValidationResult(sb, cvr.getTrustCenterReliability(), "trustCenterReliability");
        RevocationValueValidationResult revocationValueValidationResult = cvr.getRevocationValueValidationResult();
        if (revocationValueValidationResult != null) {
            String signingCertificateResultAsString = ValidationResultPrinter.printRevocationValue(revocationValueValidationResult);
            signingCertificateResultAsString = ValidationResultPrinter.indentLines(signingCertificateResultAsString);
            sb.append("Revocation value: \n");
            sb.append(signingCertificateResultAsString);
            sb.append("\n");
        }
        String string = ValidationResultPrinter.printSignature(cvr);
        sb.append(string);
        return sb.toString();
    }

    public static String printRevocationValue(RevocationValueValidationResult rvvr) {
        if (rvvr == null) {
            return "RevocationValueValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        ValidationResultPrinter.appendLine(sb, "informationSource : " + rvvr.getInformationSource());
        ValidationResultPrinter.appendLine(sb, "url : " + rvvr.getUrl());
        ValidationResultPrinter.appendLine(sb, "thisUpdate : " + rvvr.getThisUpdate());
        ValidationResultPrinter.appendLine(sb, "nextUpdate : " + rvvr.getNextUpdate());
        ValidationResultPrinter.appendValidationResult(sb, rvvr.getFreshnessCheckResult(), "freshnessCheckResult");
        ValidationResultPrinter.appendValidationResult(sb, rvvr.getCertHashCheckResult(), "certHashCheckResult");
        ValidationResultPrinter.appendValidationResult(sb, rvvr.getUpdateValueCheckResult(), "updateValueCheckResult");
        ValidationResultPrinter.appendValidationResult(sb, rvvr.getCRLIssuerCheckResult(), "crlIssuerCheckResult");
        String s = ValidationResultPrinter.printSignature(rvvr);
        sb.append(s);
        return sb.toString();
    }

    public static String printPublicKeyCertificate(PublicKeyCertificateValidationResult pkcvr) {
        if (pkcvr == null) {
            return "PublicKeyCertificateValidationResult is NULL!";
        }
        StringBuilder sb = new StringBuilder();
        boolean trustedAnchor = pkcvr.isTrustedAnchor();
        ValidationResultPrinter.appendLine(sb, "isTrustedAnchor : " + trustedAnchor);
        if (trustedAnchor) {
            ValidationResultPrinter.appendServiceInfo(sb, pkcvr);
            ValidationResultPrinter.appendTlInfo(sb, "tlInfo", pkcvr.getTSLInfo());
            ValidationResultPrinter.appendTlInfo(sb, "tlExtInfo", pkcvr.getTslExtensionInfo());
        }
        ValidationResultPrinter.appendValidationResult(sb, pkcvr.getCertChainReferencesConformance(), "certChainReferencesConformance");
        ValidationResultPrinter.appendValidationResult(sb, pkcvr.getExtensionCheck(), "extensionCheck");
        ValidationResultPrinter.appendValidationResult(sb, pkcvr.getTlValidityCheck(), "tl validity check");
        String string = ValidationResultPrinter.printCertificate(pkcvr);
        sb.append(string);
        return sb.toString();
    }

    public static void appendServiceInfo(StringBuilder sb, PublicKeyCertificateValidationResult pkcvr) {
        if (pkcvr != null) {
            sb.append("serviceInfo : ");
            ServiceInfo serviceInfo = pkcvr.getServiceInfo();
            if (serviceInfo == null) {
                sb.append("[]\n");
            } else {
                ValidationResultPrinter.appendText(sb, "\n\tserviceIdentifier : ", serviceInfo.getServiceTypeIdentifier().getValue(), "\n");
                ValidationResultPrinter.appendText(sb, "\tserviceStatus : ", serviceInfo.getServiceStatus().getValue(), "\n");
                ValidationResultPrinter.appendText(sb, "\tvalidFrom : ", serviceInfo.getValidFrom().toString(), "\n");
            }
        }
    }

    public static void appendTlInfo(StringBuilder sb, String title, TLInfo tlInfo) {
        sb.append(title);
        sb.append(" : ");
        if (tlInfo == null) {
            sb.append("[]\n");
        } else {
            ValidationResultPrinter.appendText(sb, "\n\tid : ", String.valueOf(tlInfo.getId()), "\n");
            ValidationResultPrinter.appendText(sb, "\tschemaVersion : ", String.valueOf(tlInfo.getSchemaVersion()), "\n");
            ValidationResultPrinter.appendText(sb, "\tcountryCode : ", tlInfo.getCountryCode(), "\n");
            ValidationResultPrinter.appendText(sb, "\trange : ", tlInfo.getIssueDate() + " - " + tlInfo.getNextUpdate(), "\n");
            ValidationResultPrinter.appendText(sb, "\turl : ", tlInfo.getUrl(), "\n");
        }
    }

    public static String indentLines(String stringToIndent) {
        String[] split;
        if (stringToIndent == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : split = stringToIndent.split("\n")) {
            ValidationResultPrinter.appendText(sb, "\t", s, "\n");
        }
        return sb.toString();
    }

    public static void appendLine(StringBuilder sb, String value) {
        ValidationResultPrinter.appendText(sb, "", value, "\n");
    }

    public static void appendText(StringBuilder sb, String before, String value, String after) {
        sb.append(before);
        sb.append(value);
        sb.append(after);
    }
}

