/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.validate.svp.AttributeBaseType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class SignatureAttributesUtils {
    public static final String SIGNING_TIME = "signingTime";
    public static final String SIGNING_CERTIFICATE = "signingCertificate";
    public static final String DATA_OBJECT_FORMAT = "dataObjectFormat";
    public static final String COMMITMENT_TYPE_INDICATION = "commitmentTypeIndication";
    public static final String ALL_DATA_OBJECTS_TIME_STAMP = "allDataObjectsTimeStamp";
    public static final String INDIVIDUAL_DATA_OBJECTS_TIME_STAMP = "individualDataObjectsTimeStamp";
    public static final String SIGNATURE_POLICY_IDENTIFIER = "signaturePolicyIdentifier";
    public static final String SIGNER_LOCATION = "signerLocation";
    public static final String SIGNER_ROLE = "signerRole";
    public static final String COUNTER_SIGNATURE = "counterSignature";
    public static final String SIGNATURE_TIME_STAMP = "signatureTimeStamp";
    public static final String COMPLETE_CERTIFICATE_REFS = "completeCertificateRefs";
    public static final String COMPLETE_REVOCATION_REFS = "completeRevocationRefs";
    public static final String ATTRIBUTE_CERTIFICATE_REFS = "attributeCertificateRefs";
    public static final String ATTRIBTUE_REVOCATION_REFS = "attributeRevocationRefs";
    public static final String SIG_AND_REFS_TIME_STAMP = "sigAndRefsTimeStamp";
    public static final String REFS_ONLY_TIME_STAMP = "refsOnlyTimeStamp";
    public static final String CERTIFICATE_VALUES = "certificateValues";
    public static final String REVOCATION_VALUES = "revocationValues";
    public static final String ATTR_AUTHORITIES_CERT_VALUES = "attrAuthoritiesCertValues";
    public static final String ATTRIBUTE_REVOCATION_VALUES = "attributeRevocationValues";
    public static final String TIME_STAMP_VALIDATION_DATA = "timeStampValidationData";
    public static final String ARCHIVE_TIME_STAMP = "archiveTimeStamp";
    public static final String RENEWED_DIGEST = "renewedDigest";
    public static final String MESSAGE_DIGEST = "messageDigest";
    public static final String DSS = "dss";
    public static final String VRI = "vri";
    public static final String DOC_TIME_STAMP = "docTimeStamp";
    public static final String SIGN_REASON = "signReason";
    public static final String NAME = "name";
    public static final String CONTACT_INFO = "contactInfo";
    public static final String SUB_FILTER = "subFilter";
    public static final String BYTE_RANGE = "byteRange";
    public static final String FILTER = "filter";
    public static final String CMS_ALGO_PROTECTION = "cmsAlgorithmProtection";

    public static final <T extends AttributeBaseType> T findByNameAndType(String name, Class<T> type, List<JAXBElement<? extends AttributeBaseType>> attributes) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Attribute type must not be null.");
        }
        AttributeBaseType result = null;
        if (attributes != null) {
            JAXBElement<? extends AttributeBaseType> element;
            JAXBElement<T> matchingAttribute = null;
            Iterator<JAXBElement<? extends AttributeBaseType>> iterator = attributes.iterator();
            while (iterator.hasNext() && (matchingAttribute = SignatureAttributesUtils.checkElement(name, type, element = iterator.next())) == null) {
            }
            if (matchingAttribute != null) {
                result = (AttributeBaseType)matchingAttribute.getValue();
            }
        }
        return (T)result;
    }

    private static <T extends AttributeBaseType> JAXBElement<T> checkElement(String name, Class<T> type, JAXBElement<? extends AttributeBaseType> element) {
        JAXBElement<? extends AttributeBaseType> matchingAttribute = null;
        String localPart = element.getName().getLocalPart();
        if (localPart.equals(name) && element.getValue() != null && ((AttributeBaseType)element.getValue()).getClass() == type) {
            matchingAttribute = element;
        }
        return matchingAttribute;
    }

    public static final <T extends AttributeBaseType> List<T> findAllByNameAndType(String name, Class<T> type, List<JAXBElement<? extends AttributeBaseType>> attributes) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Attribute type must not be null.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (attributes != null) {
            JAXBElement<T> matchingAttribute = null;
            for (JAXBElement<? extends AttributeBaseType> element : attributes) {
                matchingAttribute = SignatureAttributesUtils.checkElement(name, type, element);
                if (matchingAttribute == null) continue;
                result.add(matchingAttribute.getValue());
            }
        }
        return result;
    }

    private SignatureAttributesUtils() {
    }
}

