/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.core.impl.CumulatedValidationResultImpl;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import java.util.Arrays;
import java.util.List;

public class SignalAggregateUtil {
    private SignalAggregateUtil() {
    }

    public static CumulatedValidationResult aggregate(List<? extends ResultAggregator> aggregators, boolean recursive) {
        CumulatedValidationResultImpl result = null;
        for (ResultAggregator resultAggregator : aggregators) {
            int cmp;
            CumulatedValidationResult s = resultAggregator.getOverallResult(recursive);
            if (result == null && s != null) {
                result = new CumulatedValidationResultImpl(s);
                continue;
            }
            if (s == null || (cmp = result.getMajor().compareTo((Enum)s.getMajor())) > 0) continue;
            if (cmp == 0) {
                result.getMinorResults().addAll(s.getMinorResults());
                result.addMessages(s.getMessages());
                continue;
            }
            result = new CumulatedValidationResultImpl(s);
        }
        return result;
    }

    public static CumulatedValidationResult aggregateCumulated(boolean recursive, ResultAggregator ... aggregators) {
        CumulatedValidationResultImpl result = null;
        for (ResultAggregator entry : aggregators) {
            int cmp;
            if (entry == null) continue;
            CumulatedValidationResult s = entry.getOverallResult(recursive);
            if (result == null && s != null) {
                result = new CumulatedValidationResultImpl(s);
                continue;
            }
            if (s == null || (cmp = result.getMajor().compareTo((Enum)s.getMajor())) > 0) continue;
            if (cmp == 0) {
                result.getMinorResults().addAll(s.getMinorResults());
                result.addMessages(s.getMessages());
                continue;
            }
            result = new CumulatedValidationResultImpl(s);
        }
        return result;
    }

    public static CumulatedValidationResult aggregateWithAllMessages(de.governikus.csl.uom.validate.commons.ValidationResult ... results) {
        return SignalAggregateUtil.aggregate(true, Arrays.asList(results));
    }

    public static CumulatedValidationResult aggregateWithAllMessages(List<? extends de.governikus.csl.uom.validate.commons.ValidationResult> results) {
        return SignalAggregateUtil.aggregate(true, results);
    }

    public static CumulatedValidationResult aggregate(de.governikus.csl.uom.validate.commons.ValidationResult ... results) {
        return SignalAggregateUtil.aggregate(false, Arrays.asList(results));
    }

    public static CumulatedValidationResult aggregate(List<? extends de.governikus.csl.uom.validate.commons.ValidationResult> results) {
        return SignalAggregateUtil.aggregate(false, results);
    }

    public static CumulatedValidationResult aggregate(boolean allMsgs, List<? extends de.governikus.csl.uom.validate.commons.ValidationResult> results) {
        CumulatedValidationResultImpl worstResult = null;
        for (de.governikus.csl.uom.validate.commons.ValidationResult validationResult : results) {
            if (validationResult == null) continue;
            if (worstResult == null) {
                if (validationResult instanceof CumulatedValidationResult) {
                    CumulatedValidationResult cvr = (CumulatedValidationResult)validationResult;
                    worstResult = new CumulatedValidationResultImpl(cvr);
                    continue;
                }
                worstResult = new CumulatedValidationResultImpl(validationResult);
                continue;
            }
            int cmp = worstResult.getMajor().compareTo((Enum)validationResult.getMajor());
            if (cmp > 0) {
                if (!allMsgs) continue;
                worstResult.addMessages(validationResult.getMessages());
                continue;
            }
            if (cmp == 0) {
                if (validationResult instanceof CumulatedValidationResult) {
                    CumulatedValidationResult cvr = (CumulatedValidationResult)validationResult;
                    worstResult.getMinorResults().addAll(cvr.getMinorResults());
                } else {
                    worstResult.addMinorResult(validationResult.getMinor());
                }
                worstResult.addMessages(validationResult.getMessages());
                continue;
            }
            List<ValidationMessageCode> messages = worstResult.getMessages();
            if (validationResult instanceof CumulatedValidationResult) {
                CumulatedValidationResult cvr = (CumulatedValidationResult)validationResult;
                worstResult = new CumulatedValidationResultImpl(cvr);
            } else {
                worstResult = new CumulatedValidationResultImpl(validationResult);
            }
            if (!allMsgs) continue;
            worstResult.addMessages(messages);
        }
        return worstResult;
    }

    public static CumulatedValidationResult aggregateCumulated(NestedResultCumulationInstruction instruction, CumulatedValidationResult base, ResultAggregator ... aggregators) {
        CumulatedValidationResultImpl result = null;
        if (base != null) {
            result = base instanceof CumulatedValidationResultImpl ? (CumulatedValidationResultImpl)base : new CumulatedValidationResultImpl(base);
        }
        if (instruction != NestedResultCumulationInstruction.DO_NOT_INCLUDE_NESTED_RESULTS) {
            for (ResultAggregator entry : aggregators) {
                int cmp;
                if (entry == null) continue;
                CumulatedValidationResult s = entry.getOverallResult(instruction);
                if (result == null && s != null) {
                    result = new CumulatedValidationResultImpl(s);
                }
                if (s == null || (cmp = result.getMajor().compareTo((Enum)s.getMajor())) > 0) continue;
                if (cmp < 0) {
                    result = new CumulatedValidationResultImpl(s.getMajor(), (MinorResult)null);
                }
                SignalAggregateUtil.addMinorsIfRequired(result, s, instruction);
                SignalAggregateUtil.addMessagesIfRequired(result, s, instruction);
            }
        }
        return result;
    }

    private static void addMinorsIfRequired(CumulatedValidationResultImpl dest, CumulatedValidationResult origin, NestedResultCumulationInstruction instruction) {
        if (instruction.compareTo((Enum)NestedResultCumulationInstruction.INCLUDE_MAJOR) > 0) {
            dest.getMinorResults().addAll(origin.getMinorResults());
        }
    }

    private static void addMessagesIfRequired(CumulatedValidationResultImpl dest, CumulatedValidationResult origin, NestedResultCumulationInstruction instruction) {
        if (instruction.compareTo((Enum)NestedResultCumulationInstruction.INCLUDE_MINOR) > 0) {
            dest.addMessages(origin.getMessages());
        }
    }

    public static CumulatedValidationResult aggregate(List<? extends ResultAggregator> aggregators, NestedResultCumulationInstruction instruction) {
        CumulatedValidationResultImpl result = null;
        for (ResultAggregator resultAggregator : aggregators) {
            int cmp;
            CumulatedValidationResult s = resultAggregator.getOverallResult(instruction);
            if (result == null && s != null) {
                result = new CumulatedValidationResultImpl(s);
                continue;
            }
            if (s == null || (cmp = result.getMajor().compareTo((Enum)s.getMajor())) > 0) continue;
            if (cmp == 0) {
                result.getMinorResults().addAll(s.getMinorResults());
                result.addMessages(s.getMessages());
                continue;
            }
            result = new CumulatedValidationResultImpl(s);
        }
        return result;
    }

    public static CumulatedValidationResult aggregateTrustedAnchor(de.governikus.csl.uom.validate.commons.ValidationResult ... results) {
        return SignalAggregateUtil.aggregateTrustedAnchor(Arrays.asList(results));
    }

    public static CumulatedValidationResult aggregateTrustedAnchor(List<? extends de.governikus.csl.uom.validate.commons.ValidationResult> results) {
        ValidationResult res = new ValidationResult();
        res.setMajor(MajorTotalResult.NOT_VALIDATED);
        CumulatedValidationResultImpl result = new CumulatedValidationResultImpl(res);
        for (de.governikus.csl.uom.validate.commons.ValidationResult validationResult : results) {
            result.addMinorResult(validationResult.getMinor());
            result.addMessages(validationResult.getMessages());
        }
        return result;
    }
}

