/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.governikus.csl.svp.SignatureCertRefCheckResultConsumer;
import de.governikus.csl.svp.SignatureValidationResultExt;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;

public interface TimestampValidationResultExt
extends TimestampValidationResult,
SignatureValidationResultExt,
SignatureCertRefCheckResultConsumer {
    public ValidationResult getSigCertRefCheck();

    @Override
    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        CumulatedValidationResult cvr = SignatureValidationResultExt.super.getOverallResult(instruction);
        ValidationResult imprintCheck = this.getImprintCheck();
        ValidationResult sigCertRefCheck = this.getSigCertRefCheck();
        CumulatedValidationResult aggregate = SignalAggregateUtil.aggregate(imprintCheck, sigCertRefCheck, this.getAtsHashIndexValidationResult());
        return SignalAggregateUtil.aggregateCumulated(instruction, cvr, new ResultAggregator[]{aggregate});
    }

    @Override
    @JsonIgnore
    default public SignedObjectType getSignedObjectType() {
        return SignedObjectType.TIMESTAMP;
    }

    @Override
    @JsonIgnore
    default public CumulatedValidationResult getFormatCheckResult() {
        CumulatedValidationResult parentResult = SignatureValidationResultExt.super.getFormatCheckResult();
        ValidationResult hashIndexResult = this.getAtsHashIndexValidationResult();
        ValidationResult delayCheckResult = this.getTimestampDelayCheck();
        ValidationResult orderingCheckResult = this.getTimestampOrderingCheck();
        CumulatedValidationResult additionalFormatChecks = SignalAggregateUtil.aggregate(hashIndexResult, delayCheckResult, orderingCheckResult);
        return SignalAggregateUtil.aggregateCumulated(true, new ResultAggregator[]{parentResult, additionalFormatChecks});
    }

    @Override
    default public <T> T process(SignatureValidationResultVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

