/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.uom.validate.AlgorithmValidityResult;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.ERSValidationResult;
import java.util.Objects;

public interface SignatureValidationResultExt
extends SignatureValidationResult {
    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        if (this instanceof ERSValidationResult) {
            return SignalAggregateUtil.aggregate(this.getSignatureMathCheck());
        }
        CumulatedValidationResult cum1 = SignalAggregateUtil.aggregate(this.getSignatureMathCheck(), this.getTimestampDelayCheck(), this.getTimestampOrderingCheck(), this.getSigningCertificateUsageCheck(), this.getClaimedSigningTimeCheck(), this.getParseError());
        CumulatedValidationResult certResult = null;
        PublicKeyCertificateValidationResult signingCertificateValidationResult = this.getSigningCertificateValidationResult();
        if (signingCertificateValidationResult != null && instruction != NestedResultCumulationInstruction.DO_NOT_INCLUDE_NESTED_RESULTS) {
            certResult = signingCertificateValidationResult.getOverallResult(instruction);
        }
        CumulatedValidationResult algoResult = null;
        AlgorithmValidityResult signatureAlgorithmValidityAtBestPOE = this.getSignatureAlgorithmValidityAtBestPOE();
        if (signatureAlgorithmValidityAtBestPOE != null) {
            algoResult = signatureAlgorithmValidityAtBestPOE.getOverallResult(instruction);
        }
        AlgorithmValidityResult signatureAlgorithmValidityAtValidationDate = this.getSignatureAlgorithmValidityAtValidationDate();
        CumulatedValidationResult algoResult2 = null;
        if (signatureAlgorithmValidityAtValidationDate != null) {
            algoResult2 = signatureAlgorithmValidityAtValidationDate.getOverallResult(instruction);
        }
        CumulatedValidationResult algoResult3 = null;
        AlgorithmValidityResult signatureAlgorithmValidityAtClaimedSigningTime = this.getSignatureAlgorithmValidityAtClaimedSigningTime();
        if (signatureAlgorithmValidityAtClaimedSigningTime != null) {
            algoResult3 = signatureAlgorithmValidityAtClaimedSigningTime.getOverallResult(true);
        }
        if (Objects.nonNull(certResult) && certResult.getMajor().equals((Object)MajorTotalResult.TOTAL_FAILED)) {
            cum1 = SignalAggregateUtil.aggregate(new ValidationResult[]{cum1, algoResult, algoResult2, algoResult3, certResult});
            return SignalAggregateUtil.aggregateCumulated(instruction, cum1, new ResultAggregator[0]);
        }
        cum1 = SignalAggregateUtil.aggregate(new ValidationResult[]{cum1, algoResult, algoResult2, algoResult3});
        return SignalAggregateUtil.aggregateCumulated(instruction, cum1, new ResultAggregator[]{certResult});
    }

    @JsonIgnore
    default public CumulatedValidationResult getSignatureValidationIntegrityResult() {
        CumulatedValidationResult overallResult = null;
        AlgorithmValidityResult signatureAlgorithmValidityAtBestPOE = this.getSignatureAlgorithmValidityAtBestPOE();
        if (signatureAlgorithmValidityAtBestPOE != null) {
            overallResult = signatureAlgorithmValidityAtBestPOE.getOverallResult(true);
        }
        CumulatedValidationResult overallResult2 = null;
        AlgorithmValidityResult signatureAlgorithmValidityAtValidationDate = this.getSignatureAlgorithmValidityAtValidationDate();
        if (signatureAlgorithmValidityAtValidationDate != null) {
            overallResult2 = signatureAlgorithmValidityAtValidationDate.getOverallResult(true);
        }
        CumulatedValidationResult overallResult3 = null;
        AlgorithmValidityResult signatureAlgorithmValidityAtClaimedSigningTime = this.getSignatureAlgorithmValidityAtClaimedSigningTime();
        if (signatureAlgorithmValidityAtClaimedSigningTime != null) {
            overallResult3 = signatureAlgorithmValidityAtClaimedSigningTime.getOverallResult(true);
        }
        return SignalAggregateUtil.aggregate(new ValidationResult[]{SignalAggregateUtil.aggregate(this.getSignatureMathCheck()), this.getParseError(), overallResult, overallResult2, overallResult3});
    }

    default public byte[] getSignatureValue() {
        return null;
    }

    @JsonIgnore
    default public SignedObjectType getSignedObjectType() {
        return SignedObjectType.DATA;
    }

    @JsonIgnore
    default public CumulatedValidationResult getFormatCheckResult() {
        return SignalAggregateUtil.aggregate(this.getParseError());
    }

    default public <T> T process(SignatureValidationResultVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

