/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.FormatAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.EvaluatedPolicyEntry;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import java.util.Date;
import java.util.List;

public class SVPFactory {
    public static ValidationResult createResultOk() {
        ValidationResult res = new ValidationResult();
        res.setMajor(MajorTotalResult.TOTAL_PASSED);
        return res;
    }

    public static ValidationResult create(MajorTotalResult major, MinorResult minor) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        return res;
    }

    public static ValidationResult create(MajorTotalResult major, MinorResult minor, String ... messageCodes) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        List<ValidationMessageCode> messages = res.getMessages();
        for (String messageCode : messageCodes) {
            messages.add(SVPFactory.createMessageCode(messageCode));
        }
        return res;
    }

    public static ValidationResult create(MajorTotalResult major, List<ValidationMessageCode> messageCodes, MinorResult minor) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        List<ValidationMessageCode> messages = res.getMessages();
        for (ValidationMessageCode messageCode : messageCodes) {
            messages.add(messageCode);
        }
        return res;
    }

    public static ValidationMessageCode createMessageCode(String messageCode) {
        ValidationMessageCode vmc = new ValidationMessageCode();
        vmc.setMessageCode(messageCode);
        return vmc;
    }

    public static ValidationResult create(MajorTotalResult major, MinorResult minor, List<String> messageCodes) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        List<ValidationMessageCode> messages = res.getMessages();
        for (String messageCode : messageCodes) {
            messages.add(SVPFactory.createMessageCode(messageCode));
        }
        return res;
    }

    public static ValidationResult create(MajorTotalResult major, String messageCode) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        List<ValidationMessageCode> messages = res.getMessages();
        messages.add(SVPFactory.createMessageCode(messageCode));
        return res;
    }

    public static ValidationMessageCode createMessageCode(String messageCode, Object ... params) {
        ValidationMessageCode vmc = new ValidationMessageCode();
        vmc.setMessageCode(messageCode);
        for (Object param : params) {
            vmc.addParam(param);
        }
        return vmc;
    }

    public static ValidationResult create(MajorTotalResult major, MinorResult minor, ValidationMessageCode messageCode) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        List<ValidationMessageCode> messages = res.getMessages();
        messages.add(messageCode);
        return res;
    }

    public static ValidationResult createWithArg(MajorTotalResult major, MinorResult minor, String msgCode, Object ... msgArgs) {
        ValidationResult res = new ValidationResult();
        res.setMajor(major);
        res.setMinor(minor);
        List<ValidationMessageCode> messages = res.getMessages();
        messages.add(SVPFactory.createMessageCode(msgCode, msgArgs));
        return res;
    }

    public static de.governikus.csl.validate.svp.SignatureAlgorithm createSignatureAlgorithm(SignatureAlgorithm sigAlg) {
        DigestAlgorithm digestAlgorithm;
        if (sigAlg == null) {
            return null;
        }
        de.governikus.csl.validate.svp.SignatureAlgorithm result = new de.governikus.csl.validate.svp.SignatureAlgorithm();
        SignatureAlgorithmBase baseAlgorithm = sigAlg.getBaseAlgorithm();
        if (baseAlgorithm != null) {
            result.setBaseAlgorithm(baseAlgorithm);
        }
        if ((digestAlgorithm = sigAlg.getDigestAlgorithm()) != null) {
            result.setDigestAlgorithm(SVPFactory.createDigestAlgorithm(digestAlgorithm));
        }
        FormatAlgorithm formatAlgorithm = sigAlg.getFormatAlgorithm();
        result.setFormatAlgorithm(formatAlgorithm);
        PaddingAlgorithm paddingAlgorithm = sigAlg.getPaddingAlgorithm();
        if (paddingAlgorithm != null) {
            result.setPaddingAlgorithm(SVPFactory.createPaddingAlgorithm(paddingAlgorithm));
        }
        result.setJCAName(sigAlg.getJCAName());
        result.setName(sigAlg.getName());
        result.setOID(sigAlg.getOID());
        result.setURI(sigAlg.getURI());
        return result;
    }

    public static de.governikus.csl.validate.svp.PaddingAlgorithm createPaddingAlgorithm(PaddingAlgorithm paddingAlgorithm) {
        if (paddingAlgorithm == null) {
            return null;
        }
        de.governikus.csl.validate.svp.PaddingAlgorithm result = new de.governikus.csl.validate.svp.PaddingAlgorithm();
        result.setJCAName(paddingAlgorithm.getJCAName());
        result.setName(paddingAlgorithm.getName());
        result.setOID(paddingAlgorithm.getOID());
        result.setURI(paddingAlgorithm.getURI());
        return result;
    }

    public static de.governikus.csl.validate.svp.DigestAlgorithm createDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == null) {
            return null;
        }
        de.governikus.csl.validate.svp.DigestAlgorithm result = new de.governikus.csl.validate.svp.DigestAlgorithm();
        result.setDigestSize(digestAlgorithm.getDigestSize());
        result.setJCAName(digestAlgorithm.getJCAName());
        result.setName(digestAlgorithm.getName());
        result.setOID(digestAlgorithm.getOID());
        result.setURI(digestAlgorithm.getURI());
        return result;
    }

    public static ValidationResult create(de.governikus.csl.uom.validate.commons.ValidationResult parseError) {
        if (parseError == null) {
            return null;
        }
        ValidationResult vr = new ValidationResult();
        vr.setMajor(parseError.getMajor());
        vr.setMinor(parseError.getMinor());
        List messages = parseError.getMessages();
        if (messages != null) {
            List<ValidationMessageCode> messagesClone = vr.getMessages();
            for (de.governikus.csl.uom.validate.commons.ValidationMessageCode m : messages) {
                ValidationMessageCode vmc = new ValidationMessageCode();
                vmc.setMessageCode(m.getMessageCode());
                List parameters = m.getParameters();
                if (parameters != null) {
                    parameters.forEach(vmc::addParam);
                }
                messagesClone.add(vmc);
            }
        }
        return vr;
    }

    public static TypedDate createTypedDate(Date date, DateType type) {
        TypedDate td = new TypedDate();
        td.setDate(date);
        td.setType(type);
        return td;
    }

    public static EvaluatedPolicyEntry createPolicyEntry(int id, EvaluatedValidationPolicyType policy) {
        EvaluatedPolicyEntry result = new EvaluatedPolicyEntry();
        result.setId(id);
        result.setPolicy(policy);
        return result;
    }

    public static ObjectValidationResult createObjectValidationResult(String objectTypeID) {
        ObjectValidationResult inst = new ObjectValidationResult();
        inst.setObjectTypeID(objectTypeID);
        return inst;
    }
}

