/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.governikus.csl.svp.SignatureValidationResultExt;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;
import java.security.cert.X509CRL;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RevocationValueValidationResultExt
extends RevocationValueValidationResult,
SignatureValidationResultExt {
    public static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueValidationResultExt.class);

    @Override
    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        CumulatedValidationResult cvr = SignatureValidationResultExt.super.getOverallResult(instruction);
        CumulatedValidationResult s2 = SignalAggregateUtil.aggregate(this.getFreshnessCheckResult(), this.getCertHashCheckResult(), this.getUpdateValueCheckResult(), this.getRevocationValueTrustCheckResult());
        return SignalAggregateUtil.aggregate(new ValidationResult[]{cvr, s2});
    }

    @Override
    @JsonIgnore
    default public SignedObjectType getSignedObjectType() {
        if (this.getOcsp() != null) {
            return SignedObjectType.OCSP;
        }
        return SignedObjectType.CRL;
    }

    @Override
    @JsonIgnore
    default public byte[] getSignatureValue() {
        X509CRL crl = this.getCrl();
        if (crl != null) {
            return crl.getSignature();
        }
        OCSPResp ocsp = this.getOcsp();
        if (ocsp != null) {
            try {
                Object responseObject = ocsp.getResponseObject();
                if (responseObject != null) {
                    BasicOCSPResp resp = (BasicOCSPResp)responseObject;
                    return resp.getSignature();
                }
            }
            catch (OCSPException e) {
                LOGGER.info("Can't accces ocsp response", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    default public <T> T process(SignatureValidationResultVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

