/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.DigestAlgorithmValidityInformation;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;

public interface ERArchiveTimestampValidationResultExt
extends ResultAggregator {
    public TimestampValidationResult getTimestampTokenValidationResult();

    public ERHashTreeValidationResult getHashTreeValidationResult();

    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        boolean dataCovered;
        CumulatedValidationResult timestampOverallResult = this.getTimestampTokenValidationResult().getOverallResult(instruction);
        ERHashTreeValidationResult hashTreeValidationResult = this.getHashTreeValidationResult();
        if (hashTreeValidationResult == null) {
            return timestampOverallResult;
        }
        ValidationResult digestAlgorithmValidity = null;
        DigestAlgorithmValidityInformation digestAlgorithmValidationResult = hashTreeValidationResult.getDigestAlgorithmValidationResult();
        if (digestAlgorithmValidationResult != null) {
            digestAlgorithmValidity = digestAlgorithmValidationResult.getValidationResult();
        }
        ValidationResult hashContainsData = (dataCovered = hashTreeValidationResult.isDataCovered()) ? SVPFactory.createResultOk() : SVPFactory.create(MajorTotalResult.TOTAL_FAILED, MinorResult.HASH_FAILURE);
        return SignalAggregateUtil.aggregateCumulated(instruction, timestampOverallResult, new ResultAggregator[]{SignalAggregateUtil.aggregate(digestAlgorithmValidity, hashContainsData)});
    }
}

