/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import de.governikus.csl.svp.ObjectValidationResultExt;
import de.governikus.csl.svp.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.ContainerValidationResult;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.utils.SignalAggregateUtil;
import java.util.ArrayList;
import java.util.List;

public interface ContainerValidationResultExt
extends ContainerValidationResult,
ObjectValidationResultExt {
    @Override
    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        CumulatedValidationResult overallResult = ObjectValidationResultExt.super.getOverallResult(instruction);
        List resultsForContainedObjects = this.getResultsForContainedObjects();
        if (resultsForContainedObjects != null && instruction != NestedResultCumulationInstruction.DO_NOT_INCLUDE_NESTED_RESULTS) {
            ArrayList<CumulatedValidationResult> childsResults = new ArrayList<CumulatedValidationResult>();
            for (ObjectValidationResult result : resultsForContainedObjects) {
                CumulatedValidationResult childResult = result.getOverallResult(instruction);
                if (childResult == null) continue;
                childsResults.add(childResult);
            }
            if (overallResult != null) {
                childsResults.add(overallResult);
            }
            overallResult = SignalAggregateUtil.aggregate(childsResults, instruction);
        }
        return overallResult;
    }

    @Override
    default public <T> T process(ObjectValidationResultVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

