/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.governikus.csl.svp.SignatureValidationResultExt;
import de.governikus.csl.uom.validate.CertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;
import java.util.List;

public interface CertificateValidationResultExt
extends CertificateValidationResult,
SignatureValidationResultExt {
    @Override
    default public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        CumulatedValidationResult s2;
        CumulatedValidationResult s1 = SignatureValidationResultExt.super.getOverallResult(instruction);
        CumulatedValidationResult s3 = SignalAggregateUtil.aggregate(new ValidationResult[]{s1, s2 = SignalAggregateUtil.aggregate(this.getRevocationStatusCheck(), this.getTrustCenterReliability(), this.getValidityCheck(), this.getCvsResponseSignatureValidationResult(), this.getCvsForwardedResponseSignatureValidationResult(), this.getCertChainCheck(), this.getRevocationTrustCheckResult())});
        List messages = s3.getMessages();
        if (messages != null && !messages.isEmpty() && messages.stream().map(ValidationMessageCode::getMessageCode).anyMatch(mc -> mc.equals("cert_as_trusted_anchor_by_tsl"))) {
            return SignalAggregateUtil.aggregateTrustedAnchor(new ValidationResult[]{s3});
        }
        RevocationValueValidationResult revocationValueValidationResult = this.getRevocationValueValidationResult();
        if (revocationValueValidationResult != null && instruction != NestedResultCumulationInstruction.DO_NOT_INCLUDE_NESTED_RESULTS) {
            CumulatedValidationResult s4 = revocationValueValidationResult.getOverallResult(instruction);
            return SignalAggregateUtil.aggregateCumulated(instruction, s3, new ResultAggregator[]{s4});
        }
        return s3;
    }

    @Override
    @JsonIgnore
    default public SignedObjectType getSignedObjectType() {
        return SignedObjectType.CERTIFICATE;
    }
}

