/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.svp;

import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CertificateAdapter
extends XmlAdapter<String, X509CertificateImpl> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509CertificateImpl unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        byte[] binary = Base64.getMimeDecoder().decode(v);
        CertificateFactory certificateFactoryInstance = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(binary);){
            X509Certificate cert = (X509Certificate)certificateFactoryInstance.generateCertificate(bais);
            X509CertificateImpl x509CertificateImpl = new X509CertificateImpl(cert);
            return x509CertificateImpl;
        }
    }

    public String marshal(X509CertificateImpl v) throws Exception {
        if (v == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(v.getEncoded());
    }
}

