/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.core.impl;

import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class CumulatedValidationResultImpl
implements CumulatedValidationResult {
    private final Set<MinorResult> minorResults = new TreeSet<MinorResult>();
    private final MajorTotalResult major;
    private List<ValidationMessageCode> messages;

    public CumulatedValidationResultImpl() {
        this.major = MajorTotalResult.TOTAL_PASSED;
    }

    public CumulatedValidationResultImpl(MajorTotalResult major, MinorResult minor) {
        this.major = major;
        this.addMinorResult(minor);
    }

    public CumulatedValidationResultImpl(MajorTotalResult major, MinorResult ... minors) {
        this.major = major;
        for (MinorResult minor : minors) {
            this.addMinorResult(minor);
        }
    }

    public CumulatedValidationResultImpl(ValidationResult validationResult) {
        this.major = validationResult.getMajor();
        this.addMinorResult(validationResult.getMinor());
        this.addMessages(validationResult.getMessages());
    }

    public CumulatedValidationResultImpl(CumulatedValidationResult validationResult) {
        this.major = validationResult.getMajor();
        this.minorResults.addAll(validationResult.getMinorResults());
        this.addMessages(validationResult.getMessages());
    }

    public final void addMinorResult(MinorResult mr) {
        if (mr == null) {
            return;
        }
        this.minorResults.add(mr);
    }

    public MajorTotalResult getMajor() {
        return this.major;
    }

    public MinorResult getMinor() {
        if (this.minorResults.size() > 0) {
            return this.minorResults.iterator().next();
        }
        return null;
    }

    public List<ValidationMessageCode> getMessages() {
        return this.messages;
    }

    public final void addMessage(ValidationMessageCode s) {
        if (this.messages == null) {
            this.messages = new ArrayList<ValidationMessageCode>();
        }
        this.addMessageInternal(s);
    }

    private void addMessageInternal(ValidationMessageCode s) {
        if (!this.messages.contains(s)) {
            this.messages.add(s);
        }
    }

    public final void addMessages(List<? extends ValidationMessageCode> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.messages == null) {
            this.messages = new ArrayList<ValidationMessageCode>();
        }
        for (ValidationMessageCode validationMessageCode : list) {
            this.addMessageInternal(validationMessageCode);
        }
    }

    public Set<MinorResult> getMinorResults() {
        return this.minorResults;
    }

    public CumulatedValidationResult getOverallResult(boolean recursive) {
        return this;
    }

    public CumulatedValidationResult getOverallResult(NestedResultCumulationInstruction instruction) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.messages, this.minorResults);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CumulatedValidationResultImpl other = (CumulatedValidationResultImpl)obj;
        return this.major == other.major && Objects.equals(this.messages, other.messages) && Objects.equals(this.minorResults, other.minorResults);
    }
}

