/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public enum AsicContainerType {
    ASIC_S("application/vnd.etsi.asic-s+zip"),
    ASIC_E("application/vnd.etsi.asic-e+zip");

    private String mimetype;
    private byte[] mimetypeBytes;

    private AsicContainerType(String asicMimetype) {
        this.mimetype = asicMimetype;
        this.mimetypeBytes = asicMimetype.getBytes();
    }

    public static AsicContainerType parse(String value) {
        return AsicContainerType.valueOf(value);
    }

    public static String print(AsicContainerType value) {
        return value.name();
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public byte[] getMimetypeAsBytes() {
        return this.mimetypeBytes;
    }

    public static AsicContainerType fromMimetype(String mimetype) {
        for (AsicContainerType type : AsicContainerType.values()) {
            if (!type.mimetype.equals(mimetype)) continue;
            return type;
        }
        throw new IllegalArgumentException("Cannot create " + AsicContainerType.class.getSimpleName() + " for mimetype '" + mimetype + "'");
    }

    public static AsicContainerType fromMimetypeBytes(byte[] mimetypeBytes) {
        for (AsicContainerType type : AsicContainerType.values()) {
            if (!Arrays.equals(type.mimetypeBytes, mimetypeBytes)) continue;
            return type;
        }
        throw new IllegalArgumentException("Cannot create " + AsicContainerType.class.getSimpleName() + " for mimetype bytes '" + Hex.toHexString((byte[])mimetypeBytes) + "'");
    }
}

